/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store.schema;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.charset.StandardCharsets;
import org.apache.bifromq.util.BSUtil;

public class KVSchemaUtil {
    public static final ByteString SCHEMA_VER = ByteString.copyFrom((byte[])new byte[]{1});
    private static final ByteString QOS0_QUEUE_SIGN = ByteString.copyFrom((byte[])new byte[]{0});
    private static final ByteString SEND_BUFFER_SIGN = ByteString.copyFrom((byte[])new byte[]{1});
    private static final int MAX_BUCKETS = 255;

    public static ByteString tenantBeginKeyPrefix(String tenantId) {
        ByteString tenantIdBS = UnsafeByteOperations.unsafeWrap((byte[])tenantId.getBytes(StandardCharsets.UTF_8));
        return SCHEMA_VER.concat(BSUtil.toByteString((short)((short)tenantIdBS.size()))).concat(tenantIdBS);
    }

    private static short tenantIdLength(ByteString key) {
        return BSUtil.toShort((ByteString)key.substring(SCHEMA_VER.size(), SCHEMA_VER.size() + 2));
    }

    private static int tenantBeginKeyPrefixLength(ByteString key) {
        return SCHEMA_VER.size() + 2 + KVSchemaUtil.tenantIdLength(key);
    }

    private static int inboxBucketStartKeyPrefixLength(ByteString key) {
        int tenantPrefixLength = KVSchemaUtil.tenantBeginKeyPrefixLength(key);
        return tenantPrefixLength + 1;
    }

    public static ByteString inboxBucketStartKeyPrefix(String tenantId, String inboxId) {
        return KVSchemaUtil.inboxBucketStartKeyPrefix(tenantId, KVSchemaUtil.bucket(inboxId));
    }

    public static ByteString inboxBucketStartKeyPrefix(String tenantId, byte bucket) {
        return KVSchemaUtil.tenantBeginKeyPrefix(tenantId).concat(UnsafeByteOperations.unsafeWrap((byte[])new byte[]{bucket}));
    }

    public static ByteString inboxStartKeyPrefix(String tenantId, String inboxId) {
        ByteString inboxIdBS = UnsafeByteOperations.unsafeWrap((byte[])inboxId.getBytes(StandardCharsets.UTF_8));
        return KVSchemaUtil.inboxBucketStartKeyPrefix(tenantId, inboxId).concat(BSUtil.toByteString((short)((short)inboxIdBS.size()))).concat(inboxIdBS);
    }

    private static byte bucket(String inboxId) {
        int hash = inboxId.hashCode();
        return (byte)((hash ^ hash >>> 16) & 0xFF);
    }

    private static short inboxIdLength(ByteString key, int tenantPrefixLength) {
        return BSUtil.toShort((ByteString)key.substring(tenantPrefixLength + 1, tenantPrefixLength + 1 + 2));
    }

    private static int inboxStartKeyPrefixLength(ByteString inboxStoreKey) {
        int tenantPrefixLength = KVSchemaUtil.tenantBeginKeyPrefixLength(inboxStoreKey);
        short inboxIdLen = KVSchemaUtil.inboxIdLength(inboxStoreKey, tenantPrefixLength);
        return tenantPrefixLength + 1 + 2 + inboxIdLen;
    }

    public static ByteString inboxInstanceStartKey(String tenantId, String inboxId, long incarnation) {
        return KVSchemaUtil.inboxStartKeyPrefix(tenantId, inboxId).concat(BSUtil.toByteString((long)incarnation));
    }

    private static int inboxInstanceStartKeyPrefixLength(ByteString inboxStoreKey) {
        return KVSchemaUtil.inboxStartKeyPrefixLength(inboxStoreKey) + 8;
    }

    public static boolean isInboxInstanceStartKey(ByteString inboxStoreKey) {
        return inboxStoreKey.size() == KVSchemaUtil.inboxInstanceStartKeyPrefixLength(inboxStoreKey);
    }

    public static boolean isInboxInstanceKey(ByteString inboxStoreKey) {
        if (inboxStoreKey.size() > SCHEMA_VER.size() + 2) {
            int tenantBeginKeyPrefixLength = KVSchemaUtil.tenantBeginKeyPrefixLength(inboxStoreKey);
            if (inboxStoreKey.size() > tenantBeginKeyPrefixLength + 1 + 2) {
                int inboxStartKeyPrefixLength = KVSchemaUtil.inboxStartKeyPrefixLength(inboxStoreKey);
                return inboxStoreKey.size() >= inboxStartKeyPrefixLength + 8;
            }
        }
        return false;
    }

    public static ByteString parseInboxStartKeyPrefix(ByteString inboxInstanceStartKey) {
        return inboxInstanceStartKey.substring(0, inboxInstanceStartKey.size() - 8);
    }

    public static String parseTenantId(ByteString inboxStoreKey) {
        short tenantIdLength = KVSchemaUtil.tenantIdLength(inboxStoreKey);
        int startAt = SCHEMA_VER.size() + 2;
        return inboxStoreKey.substring(startAt, startAt + tenantIdLength).toStringUtf8();
    }

    public static ByteString parseInboxBucketPrefix(ByteString inboxKey) {
        return inboxKey.substring(0, KVSchemaUtil.inboxBucketStartKeyPrefixLength(inboxKey));
    }

    public static ByteString parseInboxInstanceStartKeyPrefix(ByteString inboxKey) {
        return inboxKey.substring(0, KVSchemaUtil.inboxInstanceStartKeyPrefixLength(inboxKey));
    }

    public static ByteString qos0QueuePrefix(ByteString inboxInstanceStartKey) {
        return inboxInstanceStartKey.concat(QOS0_QUEUE_SIGN);
    }

    public static ByteString qos0MsgKey(ByteString inboxInstanceStartKey, long seq) {
        return KVSchemaUtil.qos0QueuePrefix(inboxInstanceStartKey).concat(BSUtil.toByteString((long)seq));
    }

    public static ByteString sendBufferPrefix(ByteString inboxInstanceStartKey) {
        return inboxInstanceStartKey.concat(SEND_BUFFER_SIGN);
    }

    public static ByteString bufferedMsgKey(ByteString inboxInstanceStartKey, long seq) {
        return KVSchemaUtil.sendBufferPrefix(inboxInstanceStartKey).concat(BSUtil.toByteString((long)seq));
    }

    public static long parseSeq(ByteString inboxInstanceStartKey, ByteString inboxMsgKey) {
        return inboxMsgKey.substring(inboxInstanceStartKey.size() + 1).asReadOnlyByteBuffer().getLong();
    }
}

