/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.Reject;
import org.apache.bifromq.type.ClientInfo;

class WebHookBasedAuthProvider
implements IAuthProvider {
    private final URI webhookURI;
    private final HttpClient httpClient;

    WebHookBasedAuthProvider(URI webhookURI) {
        this.webhookURI = webhookURI;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData authData) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.valueOf(this.webhookURI) + "/auth")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(JsonFormat.printer().print((MessageOrBuilder)authData))).timeout(Duration.ofSeconds(5L)).build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    try {
                        MQTT3AuthResult.Builder resultBuilder = MQTT3AuthResult.newBuilder();
                        JsonFormat.parser().ignoringUnknownFields().merge((String)response.body(), (Message.Builder)resultBuilder);
                        return resultBuilder.build();
                    }
                    catch (Throwable e) {
                        return MQTT3AuthResult.newBuilder().setReject(Reject.newBuilder().setCode(Reject.Code.Error).setReason(e.getMessage()).build()).build();
                    }
                }
                return MQTT3AuthResult.newBuilder().setReject(Reject.newBuilder().setCode(Reject.Code.Error).setReason("Authenticate failed").build()).build();
            })).exceptionally(e -> {
                System.out.println("Failed to call webhook: " + e.getMessage());
                return null;
            });
        }
        catch (Throwable e2) {
            return CompletableFuture.completedFuture(MQTT3AuthResult.newBuilder().setReject(Reject.newBuilder().setCode(Reject.Code.Error).setReason(e2.getMessage()).build()).build());
        }
    }

    public CompletableFuture<Boolean> check(ClientInfo client, MQTTAction action) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.valueOf(this.webhookURI) + "/check")).header("Content-Type", "application/json").header("tenant_id", client.getTenantId()).header("user_id", (String)client.getMetadataMap().get("userId")).POST(HttpRequest.BodyPublishers.ofString(JsonFormat.printer().print((MessageOrBuilder)action))).timeout(Duration.ofSeconds(5L)).build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    try {
                        return Boolean.parseBoolean((String)response.body());
                    }
                    catch (Throwable e) {
                        return false;
                    }
                }
                return false;
            })).exceptionally(e -> {
                System.out.println("Failed to call webhook: " + e.getMessage());
                return null;
            });
        }
        catch (Throwable e2) {
            return CompletableFuture.completedFuture(false);
        }
    }
}

