/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.google.protobuf.Struct;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.worker.DistWorker;
import org.apache.bifromq.dist.worker.IDistWorker;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.sysprops.props.DistFanOutParallelism;
import org.apache.bifromq.sysprops.props.DistInlineFanOutThreshold;

public class DistWorkerBuilder {
    String clusterId = "dist.worker";
    RPCServerBuilder rpcServerBuilder;
    IAgentHost agentHost;
    IBaseKVMetaService metaService;
    int workerThreads;
    int tickerThreads;
    ScheduledExecutorService bgTaskExecutor;
    IEventCollector eventCollector;
    IResourceThrottler resourceThrottler;
    IDistClient distClient;
    IBaseKVStoreClient distWorkerClient;
    ISubBrokerManager subBrokerManager;
    ISettingProvider settingProvider;
    KVRangeStoreOptions storeOptions;
    Duration minGCInterval = Duration.ofMinutes(5L);
    Duration maxGCInterval = Duration.ofHours(24L);
    Duration bootstrapDelay = Duration.ofSeconds(15L);
    Duration zombieProbeDelay = Duration.ofSeconds(15L);
    Duration balancerRetryDelay = Duration.ofSeconds(5L);
    Map<String, Struct> balancerFactoryConfig = new HashMap<String, Struct>();
    int fanoutParallelism = (Integer)DistFanOutParallelism.INSTANCE.get();
    int inlineFanoutThreshold = (Integer)DistInlineFanOutThreshold.INSTANCE.get();
    Map<String, String> attributes = new HashMap<String, String>();

    public IDistWorker build() {
        return new DistWorker(this);
    }

    @Generated
    DistWorkerBuilder() {
    }

    @Generated
    public DistWorkerBuilder clusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Generated
    public DistWorkerBuilder rpcServerBuilder(RPCServerBuilder rpcServerBuilder) {
        this.rpcServerBuilder = rpcServerBuilder;
        return this;
    }

    @Generated
    public DistWorkerBuilder agentHost(IAgentHost agentHost) {
        this.agentHost = agentHost;
        return this;
    }

    @Generated
    public DistWorkerBuilder metaService(IBaseKVMetaService metaService) {
        this.metaService = metaService;
        return this;
    }

    @Generated
    public DistWorkerBuilder workerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    @Generated
    public DistWorkerBuilder tickerThreads(int tickerThreads) {
        this.tickerThreads = tickerThreads;
        return this;
    }

    @Generated
    public DistWorkerBuilder bgTaskExecutor(ScheduledExecutorService bgTaskExecutor) {
        this.bgTaskExecutor = bgTaskExecutor;
        return this;
    }

    @Generated
    public DistWorkerBuilder eventCollector(IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        return this;
    }

    @Generated
    public DistWorkerBuilder resourceThrottler(IResourceThrottler resourceThrottler) {
        this.resourceThrottler = resourceThrottler;
        return this;
    }

    @Generated
    public DistWorkerBuilder distClient(IDistClient distClient) {
        this.distClient = distClient;
        return this;
    }

    @Generated
    public DistWorkerBuilder distWorkerClient(IBaseKVStoreClient distWorkerClient) {
        this.distWorkerClient = distWorkerClient;
        return this;
    }

    @Generated
    public DistWorkerBuilder subBrokerManager(ISubBrokerManager subBrokerManager) {
        this.subBrokerManager = subBrokerManager;
        return this;
    }

    @Generated
    public DistWorkerBuilder settingProvider(ISettingProvider settingProvider) {
        this.settingProvider = settingProvider;
        return this;
    }

    @Generated
    public DistWorkerBuilder storeOptions(KVRangeStoreOptions storeOptions) {
        this.storeOptions = storeOptions;
        return this;
    }

    @Generated
    public DistWorkerBuilder minGCInterval(Duration minGCInterval) {
        this.minGCInterval = minGCInterval;
        return this;
    }

    @Generated
    public DistWorkerBuilder maxGCInterval(Duration maxGCInterval) {
        this.maxGCInterval = maxGCInterval;
        return this;
    }

    @Generated
    public DistWorkerBuilder bootstrapDelay(Duration bootstrapDelay) {
        this.bootstrapDelay = bootstrapDelay;
        return this;
    }

    @Generated
    public DistWorkerBuilder zombieProbeDelay(Duration zombieProbeDelay) {
        this.zombieProbeDelay = zombieProbeDelay;
        return this;
    }

    @Generated
    public DistWorkerBuilder balancerRetryDelay(Duration balancerRetryDelay) {
        this.balancerRetryDelay = balancerRetryDelay;
        return this;
    }

    @Generated
    public DistWorkerBuilder balancerFactoryConfig(Map<String, Struct> balancerFactoryConfig) {
        this.balancerFactoryConfig = balancerFactoryConfig;
        return this;
    }

    @Generated
    public DistWorkerBuilder fanoutParallelism(int fanoutParallelism) {
        this.fanoutParallelism = fanoutParallelism;
        return this;
    }

    @Generated
    public DistWorkerBuilder inlineFanoutThreshold(int inlineFanoutThreshold) {
        this.inlineFanoutThreshold = inlineFanoutThreshold;
        return this;
    }

    @Generated
    public DistWorkerBuilder attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }
}

