/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.util;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.bifromq.basecrdt.store.proto.EventIndex;

public class ProtoUtil {
    public static List<EventIndex> to(Map<ByteString, NavigableMap<Long, Long>> latticeEvents) {
        ArrayList<EventIndex> histories = new ArrayList<EventIndex>(latticeEvents.size());
        latticeEvents.forEach((k, v) -> {
            EventIndex.Builder builder = EventIndex.newBuilder().setReplicaId((ByteString)k);
            v.forEach(builder::putRanges);
            histories.add(builder.build());
        });
        return histories;
    }

    public static Map<ByteString, NavigableMap<Long, Long>> to(List<EventIndex> eventIndexList) {
        HashMap map = Maps.newHashMap();
        for (EventIndex idx : eventIndexList) {
            Map ranges = map.computeIfAbsent(idx.getReplicaId(), k -> Maps.newTreeMap());
            ranges.putAll(idx.getRangesMap());
        }
        return map;
    }
}

