/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.IOException;
import java.io.InputStream;

public class GridFixedSizeInputStream
extends InputStream {
    private final InputStream in;
    private long size;

    public GridFixedSizeInputStream(InputStream in, long size) {
        this.in = in;
        this.size = size;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res;
        assert (len <= b.length);
        if (this.size == 0L) {
            return -1;
        }
        if ((long)len > this.size) {
            len = (int)this.size;
        }
        if ((res = this.in.read(b, off, len)) == -1) {
            throw new IOException("Expected " + this.size + " more bytes to read.");
        }
        assert (res >= 0) : res;
        this.size -= (long)res;
        assert (this.size >= 0L) : this.size;
        return res;
    }

    @Override
    public int available() throws IOException {
        return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
    }

    @Override
    public int read() throws IOException {
        if (this.size == 0L) {
            return -1;
        }
        int res = this.in.read();
        if (res == -1) {
            throw new IOException("Expected " + this.size + " more bytes to read.");
        }
        --this.size;
        return res;
    }
}

