/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.parser.SqlParserPos;

public class DerbySqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.DERBY);
    public static final SqlDialect DEFAULT = new DerbySqlDialect(DEFAULT_CONTEXT);

    public DerbySqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case CHAR_LENGTH: {
                SqlCall lengthCall = SqlLibraryOperators.LENGTH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, lengthCall, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }
}

