/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAttributeListener
implements ServletContextListener,
ServletContextAttributeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedAttributeListener.class);
    final Set<String> _managedAttributes = new HashSet<String>();
    final ServletContextHandler _context;

    public ManagedAttributeListener(ServletContextHandler context, String ... managedAttributes) {
        this._context = context;
        this._managedAttributes.addAll(Arrays.asList(managedAttributes));
        if (LOG.isDebugEnabled()) {
            LOG.debug("managedAttributes {}", this._managedAttributes);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        if (this._managedAttributes.contains(event.getName())) {
            this.updateBean(event.getName(), event.getValue(), event.getServletContext().getAttribute(event.getName()));
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        if (this._managedAttributes.contains(event.getName())) {
            this.updateBean(event.getName(), event.getValue(), null);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        if (this._managedAttributes.contains(event.getName())) {
            this.updateBean(event.getName(), null, event.getValue());
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        Enumeration attributeNames = this._context.getServletContext().getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if (!this._managedAttributes.contains(name)) continue;
            this.updateBean(name, null, event.getServletContext().getAttribute(name));
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        Enumeration attributeNames = this._context.getServletContext().getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if (!this._managedAttributes.contains(name)) continue;
            this.updateBean(name, event.getServletContext().getAttribute(name), null);
        }
    }

    protected void updateBean(String name, Object oldBean, Object newBean) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("update {} {}->{} on {}", new Object[]{name, oldBean, newBean, this._context});
        }
        this._context.updateBean(oldBean, newBean, false);
    }
}

