/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kafka.CheckStopReadingFn;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.TimestampPolicyFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;

final class AutoValue_KafkaIO_Read<K, V>
extends KafkaIO.Read<K, V> {
    private final Map<String, Object> consumerConfig;
    private final @Nullable List<String> topics;
    private final @Nullable List<TopicPartition> topicPartitions;
    private final @Nullable Pattern topicPattern;
    private final @Nullable Coder<K> keyCoder;
    private final @Nullable Coder<V> valueCoder;
    private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
    private final @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;
    private final @Nullable Instant startReadTime;
    private final @Nullable Instant stopReadTime;
    private final boolean commitOffsetsInFinalizeEnabled;
    private final boolean dynamicRead;
    private final boolean redistributed;
    private final boolean allowDuplicates;
    private final int redistributeNumKeys;
    private final @Nullable Duration watchTopicPartitionDuration;
    private final TimestampPolicyFactory<K, V> timestampPolicyFactory;
    private final @Nullable Map<String, Object> offsetConsumerConfig;
    private final @Nullable DeserializerProvider<K> keyDeserializerProvider;
    private final @Nullable DeserializerProvider<V> valueDeserializerProvider;
    private final @Nullable CheckStopReadingFn checkStopReadingFn;
    private final @Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler;
    private final long consumerPollingTimeout;

    private AutoValue_KafkaIO_Read(Map<String, Object> consumerConfig, @Nullable List<String> topics, @Nullable List<TopicPartition> topicPartitions, @Nullable Pattern topicPattern, @Nullable Coder<K> keyCoder, @Nullable Coder<V> valueCoder, SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn, @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn, long maxNumRecords, @Nullable Duration maxReadTime, @Nullable Instant startReadTime, @Nullable Instant stopReadTime, boolean commitOffsetsInFinalizeEnabled, boolean dynamicRead, boolean redistributed, boolean allowDuplicates, int redistributeNumKeys, @Nullable Duration watchTopicPartitionDuration, TimestampPolicyFactory<K, V> timestampPolicyFactory, @Nullable Map<String, Object> offsetConsumerConfig, @Nullable DeserializerProvider<K> keyDeserializerProvider, @Nullable DeserializerProvider<V> valueDeserializerProvider, @Nullable CheckStopReadingFn checkStopReadingFn, @Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler, long consumerPollingTimeout) {
        this.consumerConfig = consumerConfig;
        this.topics = topics;
        this.topicPartitions = topicPartitions;
        this.topicPattern = topicPattern;
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
        this.consumerFactoryFn = consumerFactoryFn;
        this.watermarkFn = watermarkFn;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.startReadTime = startReadTime;
        this.stopReadTime = stopReadTime;
        this.commitOffsetsInFinalizeEnabled = commitOffsetsInFinalizeEnabled;
        this.dynamicRead = dynamicRead;
        this.redistributed = redistributed;
        this.allowDuplicates = allowDuplicates;
        this.redistributeNumKeys = redistributeNumKeys;
        this.watchTopicPartitionDuration = watchTopicPartitionDuration;
        this.timestampPolicyFactory = timestampPolicyFactory;
        this.offsetConsumerConfig = offsetConsumerConfig;
        this.keyDeserializerProvider = keyDeserializerProvider;
        this.valueDeserializerProvider = valueDeserializerProvider;
        this.checkStopReadingFn = checkStopReadingFn;
        this.badRecordErrorHandler = badRecordErrorHandler;
        this.consumerPollingTimeout = consumerPollingTimeout;
    }

    @Override
    @Pure
    public Map<String, Object> getConsumerConfig() {
        return this.consumerConfig;
    }

    @Override
    @Pure
    public @Nullable List<String> getTopics() {
        return this.topics;
    }

    @Override
    @Pure
    public @Nullable List<TopicPartition> getTopicPartitions() {
        return this.topicPartitions;
    }

    @Override
    @Pure
    public @Nullable Pattern getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    @Pure
    public @Nullable Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    @Override
    @Pure
    public @Nullable Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    @Pure
    public SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> getConsumerFactoryFn() {
        return this.consumerFactoryFn;
    }

    @Override
    @Pure
    public @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> getWatermarkFn() {
        return this.watermarkFn;
    }

    @Override
    @Pure
    public long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Pure
    public @Nullable Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
    @Pure
    public @Nullable Instant getStartReadTime() {
        return this.startReadTime;
    }

    @Override
    @Pure
    public @Nullable Instant getStopReadTime() {
        return this.stopReadTime;
    }

    @Override
    @Pure
    public boolean isCommitOffsetsInFinalizeEnabled() {
        return this.commitOffsetsInFinalizeEnabled;
    }

    @Override
    @Pure
    public boolean isDynamicRead() {
        return this.dynamicRead;
    }

    @Override
    @Pure
    public boolean isRedistributed() {
        return this.redistributed;
    }

    @Override
    @Pure
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    @Pure
    public int getRedistributeNumKeys() {
        return this.redistributeNumKeys;
    }

    @Override
    @Pure
    public @Nullable Duration getWatchTopicPartitionDuration() {
        return this.watchTopicPartitionDuration;
    }

    @Override
    @Pure
    public TimestampPolicyFactory<K, V> getTimestampPolicyFactory() {
        return this.timestampPolicyFactory;
    }

    @Override
    @Pure
    public @Nullable Map<String, Object> getOffsetConsumerConfig() {
        return this.offsetConsumerConfig;
    }

    @Override
    @Pure
    public @Nullable DeserializerProvider<K> getKeyDeserializerProvider() {
        return this.keyDeserializerProvider;
    }

    @Override
    @Pure
    public @Nullable DeserializerProvider<V> getValueDeserializerProvider() {
        return this.valueDeserializerProvider;
    }

    @Override
    @Pure
    public @Nullable CheckStopReadingFn getCheckStopReadingFn() {
        return this.checkStopReadingFn;
    }

    @Override
    @Pure
    public @Nullable ErrorHandler<BadRecord, ?> getBadRecordErrorHandler() {
        return this.badRecordErrorHandler;
    }

    @Override
    @Pure
    public long getConsumerPollingTimeout() {
        return this.consumerPollingTimeout;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaIO.Read) {
            KafkaIO.Read that = (KafkaIO.Read)((Object)o);
            return this.consumerConfig.equals(that.getConsumerConfig()) && (this.topics == null ? that.getTopics() == null : this.topics.equals(that.getTopics())) && (this.topicPartitions == null ? that.getTopicPartitions() == null : this.topicPartitions.equals(that.getTopicPartitions())) && (this.topicPattern == null ? that.getTopicPattern() == null : this.topicPattern.equals(that.getTopicPattern())) && (this.keyCoder == null ? that.getKeyCoder() == null : this.keyCoder.equals(that.getKeyCoder())) && (this.valueCoder == null ? that.getValueCoder() == null : this.valueCoder.equals(that.getValueCoder())) && this.consumerFactoryFn.equals(that.getConsumerFactoryFn()) && (this.watermarkFn == null ? that.getWatermarkFn() == null : this.watermarkFn.equals(that.getWatermarkFn())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && (this.startReadTime == null ? that.getStartReadTime() == null : this.startReadTime.equals((Object)that.getStartReadTime())) && (this.stopReadTime == null ? that.getStopReadTime() == null : this.stopReadTime.equals((Object)that.getStopReadTime())) && this.commitOffsetsInFinalizeEnabled == that.isCommitOffsetsInFinalizeEnabled() && this.dynamicRead == that.isDynamicRead() && this.redistributed == that.isRedistributed() && this.allowDuplicates == that.isAllowDuplicates() && this.redistributeNumKeys == that.getRedistributeNumKeys() && (this.watchTopicPartitionDuration == null ? that.getWatchTopicPartitionDuration() == null : this.watchTopicPartitionDuration.equals((Object)that.getWatchTopicPartitionDuration())) && this.timestampPolicyFactory.equals(that.getTimestampPolicyFactory()) && (this.offsetConsumerConfig == null ? that.getOffsetConsumerConfig() == null : this.offsetConsumerConfig.equals(that.getOffsetConsumerConfig())) && (this.keyDeserializerProvider == null ? that.getKeyDeserializerProvider() == null : this.keyDeserializerProvider.equals(that.getKeyDeserializerProvider())) && (this.valueDeserializerProvider == null ? that.getValueDeserializerProvider() == null : this.valueDeserializerProvider.equals(that.getValueDeserializerProvider())) && (this.checkStopReadingFn == null ? that.getCheckStopReadingFn() == null : this.checkStopReadingFn.equals(that.getCheckStopReadingFn())) && (this.badRecordErrorHandler == null ? that.getBadRecordErrorHandler() == null : this.badRecordErrorHandler.equals(that.getBadRecordErrorHandler())) && this.consumerPollingTimeout == that.getConsumerPollingTimeout();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.consumerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.topics == null ? 0 : this.topics.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicPartitions == null ? 0 : this.topicPartitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicPattern == null ? 0 : this.topicPattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyCoder == null ? 0 : this.keyCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueCoder == null ? 0 : this.valueCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerFactoryFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.watermarkFn == null ? 0 : this.watermarkFn.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.startReadTime == null ? 0 : this.startReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.stopReadTime == null ? 0 : this.stopReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.commitOffsetsInFinalizeEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.dynamicRead ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.redistributed ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.allowDuplicates ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.redistributeNumKeys;
        h$ *= 1000003;
        h$ ^= this.watchTopicPartitionDuration == null ? 0 : this.watchTopicPartitionDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampPolicyFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.offsetConsumerConfig == null ? 0 : this.offsetConsumerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyDeserializerProvider == null ? 0 : this.keyDeserializerProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.valueDeserializerProvider == null ? 0 : this.valueDeserializerProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.checkStopReadingFn == null ? 0 : this.checkStopReadingFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.badRecordErrorHandler == null ? 0 : this.badRecordErrorHandler.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.consumerPollingTimeout >>> 32 ^ this.consumerPollingTimeout);
    }

    @Override
    KafkaIO.Read.Builder<K, V> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<K, V>
    extends KafkaIO.Read.Builder<K, V> {
        private Map<String, Object> consumerConfig;
        private @Nullable List<String> topics;
        private @Nullable List<TopicPartition> topicPartitions;
        private @Nullable Pattern topicPattern;
        private @Nullable Coder<K> keyCoder;
        private @Nullable Coder<V> valueCoder;
        private SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;
        private @Nullable SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;
        private @Nullable Instant startReadTime;
        private @Nullable Instant stopReadTime;
        private Boolean commitOffsetsInFinalizeEnabled;
        private Boolean dynamicRead;
        private Boolean redistributed;
        private Boolean allowDuplicates;
        private Integer redistributeNumKeys;
        private @Nullable Duration watchTopicPartitionDuration;
        private TimestampPolicyFactory<K, V> timestampPolicyFactory;
        private @Nullable Map<String, Object> offsetConsumerConfig;
        private @Nullable DeserializerProvider<K> keyDeserializerProvider;
        private @Nullable DeserializerProvider<V> valueDeserializerProvider;
        private @Nullable CheckStopReadingFn checkStopReadingFn;
        private @Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler;
        private Long consumerPollingTimeout;

        Builder() {
        }

        private Builder(KafkaIO.Read<K, V> source) {
            this.consumerConfig = source.getConsumerConfig();
            this.topics = source.getTopics();
            this.topicPartitions = source.getTopicPartitions();
            this.topicPattern = source.getTopicPattern();
            this.keyCoder = source.getKeyCoder();
            this.valueCoder = source.getValueCoder();
            this.consumerFactoryFn = source.getConsumerFactoryFn();
            this.watermarkFn = source.getWatermarkFn();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.startReadTime = source.getStartReadTime();
            this.stopReadTime = source.getStopReadTime();
            this.commitOffsetsInFinalizeEnabled = source.isCommitOffsetsInFinalizeEnabled();
            this.dynamicRead = source.isDynamicRead();
            this.redistributed = source.isRedistributed();
            this.allowDuplicates = source.isAllowDuplicates();
            this.redistributeNumKeys = source.getRedistributeNumKeys();
            this.watchTopicPartitionDuration = source.getWatchTopicPartitionDuration();
            this.timestampPolicyFactory = source.getTimestampPolicyFactory();
            this.offsetConsumerConfig = source.getOffsetConsumerConfig();
            this.keyDeserializerProvider = source.getKeyDeserializerProvider();
            this.valueDeserializerProvider = source.getValueDeserializerProvider();
            this.checkStopReadingFn = source.getCheckStopReadingFn();
            this.badRecordErrorHandler = source.getBadRecordErrorHandler();
            this.consumerPollingTimeout = source.getConsumerPollingTimeout();
        }

        @Override
        KafkaIO.Read.Builder<K, V> setConsumerConfig(Map<String, Object> consumerConfig) {
            if (consumerConfig == null) {
                throw new NullPointerException("Null consumerConfig");
            }
            this.consumerConfig = consumerConfig;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTopics(List<String> topics) {
            this.topics = topics;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTopicPartitions(List<TopicPartition> topicPartitions) {
            this.topicPartitions = topicPartitions;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTopicPattern(Pattern topicPattern) {
            this.topicPattern = topicPattern;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setKeyCoder(Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setValueCoder(Coder<V> valueCoder) {
            this.valueCoder = valueCoder;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setConsumerFactoryFn(SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn) {
            if (consumerFactoryFn == null) {
                throw new NullPointerException("Null consumerFactoryFn");
            }
            this.consumerFactoryFn = consumerFactoryFn;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setWatermarkFn(SerializableFunction<KafkaRecord<K, V>, Instant> watermarkFn) {
            this.watermarkFn = watermarkFn;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setStartReadTime(Instant startReadTime) {
            this.startReadTime = startReadTime;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setStopReadTime(Instant stopReadTime) {
            this.stopReadTime = stopReadTime;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setCommitOffsetsInFinalizeEnabled(boolean commitOffsetsInFinalizeEnabled) {
            this.commitOffsetsInFinalizeEnabled = commitOffsetsInFinalizeEnabled;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setDynamicRead(boolean dynamicRead) {
            this.dynamicRead = dynamicRead;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setRedistributed(boolean redistributed) {
            this.redistributed = redistributed;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setAllowDuplicates(boolean allowDuplicates) {
            this.allowDuplicates = allowDuplicates;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setRedistributeNumKeys(int redistributeNumKeys) {
            this.redistributeNumKeys = redistributeNumKeys;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setWatchTopicPartitionDuration(Duration watchTopicPartitionDuration) {
            this.watchTopicPartitionDuration = watchTopicPartitionDuration;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setTimestampPolicyFactory(TimestampPolicyFactory<K, V> timestampPolicyFactory) {
            if (timestampPolicyFactory == null) {
                throw new NullPointerException("Null timestampPolicyFactory");
            }
            this.timestampPolicyFactory = timestampPolicyFactory;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setOffsetConsumerConfig(Map<String, Object> offsetConsumerConfig) {
            this.offsetConsumerConfig = offsetConsumerConfig;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setKeyDeserializerProvider(DeserializerProvider<K> keyDeserializerProvider) {
            this.keyDeserializerProvider = keyDeserializerProvider;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setValueDeserializerProvider(DeserializerProvider<V> valueDeserializerProvider) {
            this.valueDeserializerProvider = valueDeserializerProvider;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setCheckStopReadingFn(@Nullable CheckStopReadingFn checkStopReadingFn) {
            this.checkStopReadingFn = checkStopReadingFn;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setBadRecordErrorHandler(@Nullable ErrorHandler<BadRecord, ?> badRecordErrorHandler) {
            this.badRecordErrorHandler = badRecordErrorHandler;
            return this;
        }

        @Override
        KafkaIO.Read.Builder<K, V> setConsumerPollingTimeout(long consumerPollingTimeout) {
            this.consumerPollingTimeout = consumerPollingTimeout;
            return this;
        }

        @Override
        KafkaIO.Read<K, V> build() {
            if (this.consumerConfig == null || this.consumerFactoryFn == null || this.maxNumRecords == null || this.commitOffsetsInFinalizeEnabled == null || this.dynamicRead == null || this.redistributed == null || this.allowDuplicates == null || this.redistributeNumKeys == null || this.timestampPolicyFactory == null || this.consumerPollingTimeout == null) {
                StringBuilder missing = new StringBuilder();
                if (this.consumerConfig == null) {
                    missing.append(" consumerConfig");
                }
                if (this.consumerFactoryFn == null) {
                    missing.append(" consumerFactoryFn");
                }
                if (this.maxNumRecords == null) {
                    missing.append(" maxNumRecords");
                }
                if (this.commitOffsetsInFinalizeEnabled == null) {
                    missing.append(" commitOffsetsInFinalizeEnabled");
                }
                if (this.dynamicRead == null) {
                    missing.append(" dynamicRead");
                }
                if (this.redistributed == null) {
                    missing.append(" redistributed");
                }
                if (this.allowDuplicates == null) {
                    missing.append(" allowDuplicates");
                }
                if (this.redistributeNumKeys == null) {
                    missing.append(" redistributeNumKeys");
                }
                if (this.timestampPolicyFactory == null) {
                    missing.append(" timestampPolicyFactory");
                }
                if (this.consumerPollingTimeout == null) {
                    missing.append(" consumerPollingTimeout");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaIO_Read(this.consumerConfig, this.topics, this.topicPartitions, this.topicPattern, this.keyCoder, this.valueCoder, this.consumerFactoryFn, this.watermarkFn, this.maxNumRecords, this.maxReadTime, this.startReadTime, this.stopReadTime, this.commitOffsetsInFinalizeEnabled, this.dynamicRead, this.redistributed, this.allowDuplicates, this.redistributeNumKeys, this.watchTopicPartitionDuration, this.timestampPolicyFactory, this.offsetConsumerConfig, this.keyDeserializerProvider, this.valueDeserializerProvider, this.checkStopReadingFn, this.badRecordErrorHandler, this.consumerPollingTimeout);
        }
    }
}

