/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.BroadcastStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.BroadcastProcessFunction;
import org.apache.flink.streaming.api.functions.co.KeyedBroadcastProcessFunction;
import org.apache.flink.streaming.api.transformations.BroadcastStateTransformation;
import org.apache.flink.streaming.api.transformations.KeyedBroadcastStateTransformation;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class BroadcastConnectedStream<IN1, IN2> {
    private final StreamExecutionEnvironment environment;
    private final DataStream<IN1> nonBroadcastStream;
    private final BroadcastStream<IN2> broadcastStream;
    private final List<MapStateDescriptor<?, ?>> broadcastStateDescriptors;

    protected BroadcastConnectedStream(StreamExecutionEnvironment env, DataStream<IN1> input1, BroadcastStream<IN2> input2, List<MapStateDescriptor<?, ?>> broadcastStateDescriptors) {
        this.environment = Objects.requireNonNull(env);
        this.nonBroadcastStream = Objects.requireNonNull(input1);
        this.broadcastStream = Objects.requireNonNull(input2);
        this.broadcastStateDescriptors = Objects.requireNonNull(broadcastStateDescriptors);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public DataStream<IN1> getFirstInput() {
        return this.nonBroadcastStream;
    }

    public BroadcastStream<IN2> getSecondInput() {
        return this.broadcastStream;
    }

    public TypeInformation<IN1> getType1() {
        return this.nonBroadcastStream.getType();
    }

    public TypeInformation<IN2> getType2() {
        return this.broadcastStream.getType();
    }

    @PublicEvolving
    public <KEY, OUT> SingleOutputStreamOperator<OUT> process(KeyedBroadcastProcessFunction<KEY, IN1, IN2, OUT> function) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(function, KeyedBroadcastProcessFunction.class, (int)1, (int)2, (int)3, (int[])TypeExtractor.NO_INDEX, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.process(function, outTypeInfo);
    }

    @PublicEvolving
    public <KEY, OUT> SingleOutputStreamOperator<OUT> process(KeyedBroadcastProcessFunction<KEY, IN1, IN2, OUT> function, TypeInformation<OUT> outTypeInfo) {
        Preconditions.checkNotNull(function);
        Preconditions.checkArgument((boolean)(this.nonBroadcastStream instanceof KeyedStream), (Object)"A KeyedBroadcastProcessFunction can only be used on a keyed stream.");
        return this.transform(function, outTypeInfo);
    }

    @PublicEvolving
    public <OUT> SingleOutputStreamOperator<OUT> process(BroadcastProcessFunction<IN1, IN2, OUT> function) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(function, BroadcastProcessFunction.class, (int)0, (int)1, (int)2, (int[])TypeExtractor.NO_INDEX, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.process(function, outTypeInfo);
    }

    @PublicEvolving
    public <OUT> SingleOutputStreamOperator<OUT> process(BroadcastProcessFunction<IN1, IN2, OUT> function, TypeInformation<OUT> outTypeInfo) {
        Preconditions.checkNotNull(function);
        Preconditions.checkArgument((!(this.nonBroadcastStream instanceof KeyedStream) ? 1 : 0) != 0, (Object)"A BroadcastProcessFunction can only be used on a non-keyed stream.");
        return this.transform(function, outTypeInfo);
    }

    @Internal
    private <OUT> SingleOutputStreamOperator<OUT> transform(BroadcastProcessFunction<IN1, IN2, OUT> userFunction, TypeInformation<OUT> outTypeInfo) {
        this.nonBroadcastStream.getType();
        this.broadcastStream.getType();
        BroadcastStateTransformation<IN1, IN2, OUT> transformation = new BroadcastStateTransformation<IN1, IN2, OUT>("Co-Process-Broadcast", this.nonBroadcastStream.getTransformation(), this.broadcastStream.getTransformation(), this.clean((Object)userFunction), this.broadcastStateDescriptors, outTypeInfo, this.environment.getParallelism(), false);
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, transformation);
        this.getExecutionEnvironment().addOperator(transformation);
        return returnStream;
    }

    @Internal
    private <KEY, OUT> SingleOutputStreamOperator<OUT> transform(KeyedBroadcastProcessFunction<KEY, IN1, IN2, OUT> userFunction, TypeInformation<OUT> outTypeInfo) {
        this.nonBroadcastStream.getType();
        this.broadcastStream.getType();
        KeyedStream keyedInputStream = (KeyedStream)this.nonBroadcastStream;
        KeyedBroadcastStateTransformation<KEY, IN1, IN2, OUT> transformation = new KeyedBroadcastStateTransformation<KEY, IN1, IN2, OUT>("Co-Process-Broadcast-Keyed", this.nonBroadcastStream.getTransformation(), this.broadcastStream.getTransformation(), this.clean((Object)userFunction), this.broadcastStateDescriptors, keyedInputStream.getKeyType(), keyedInputStream.getKeySelector(), outTypeInfo, this.environment.getParallelism(), false);
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, transformation);
        this.getExecutionEnvironment().addOperator(transformation);
        return returnStream;
    }

    protected <F> F clean(F f) {
        return this.getExecutionEnvironment().clean(f);
    }
}

