/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc;

import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContextManager;
import org.springframework.lang.NonNull;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class TransactionContext
implements TransactionStatus,
AutoCloseable {
    private final TransactionStatus transactionStatus;
    private final TransactionContextManager transactionManager;

    TransactionContext(TransactionStatus transactionStatus, TransactionContextManager transactionManager) {
        this.transactionStatus = transactionStatus;
        this.transactionManager = transactionManager;
    }

    public boolean hasSavepoint() {
        return this.transactionStatus.hasSavepoint();
    }

    public void flush() {
        this.transactionStatus.flush();
    }

    @NonNull
    public Object createSavepoint() throws TransactionException {
        return this.transactionStatus.createSavepoint();
    }

    public void rollbackToSavepoint(@NonNull Object savepoint) throws TransactionException {
        this.transactionStatus.rollbackToSavepoint(savepoint);
    }

    public void releaseSavepoint(@NonNull Object savepoint) throws TransactionException {
        this.transactionStatus.releaseSavepoint(savepoint);
    }

    public boolean isNewTransaction() {
        return this.transactionStatus.isNewTransaction();
    }

    public void setRollbackOnly() {
        this.transactionStatus.setRollbackOnly();
    }

    public boolean isRollbackOnly() {
        return this.transactionStatus.isRollbackOnly();
    }

    public boolean isCompleted() {
        return this.transactionStatus.isCompleted();
    }

    TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Override
    public void close() {
        this.transactionManager.rollbackIfNotCommitted(this);
    }
}

