/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.SupportsSchemas;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericSchema;
import org.apache.gravitino.client.MetadataObjectCredentialOperations;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.SchemaCreateRequest;
import org.apache.gravitino.dto.requests.SchemaUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.SchemaResponse;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

abstract class BaseSchemaCatalog
extends CatalogDTO
implements Catalog,
SupportsSchemas,
SupportsTags,
SupportsRoles,
SupportsPolicies {
    protected final RESTClient restClient;
    private final Namespace catalogNamespace;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;
    private final MetadataObjectRoleOperations objectRoleOperations;
    protected final MetadataObjectCredentialOperations objectCredentialOperations;

    BaseSchemaCatalog(Namespace catalogNamespace, String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(name, type, provider, comment, properties, auditDTO);
        this.restClient = restClient;
        Namespace.check((catalogNamespace != null && catalogNamespace.length() == 1 ? 1 : 0) != 0, (String)"Catalog namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{catalogNamespace});
        this.catalogNamespace = catalogNamespace;
        MetadataObject metadataObject = MetadataObjects.of(null, (String)this.name(), (MetadataObject.Type)MetadataObject.Type.CATALOG);
        this.objectTagOperations = new MetadataObjectTagOperations(catalogNamespace.level(0), metadataObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(catalogNamespace.level(0), metadataObject, restClient);
        this.objectRoleOperations = new MetadataObjectRoleOperations(catalogNamespace.level(0), metadataObject, restClient);
        this.objectCredentialOperations = new MetadataObjectCredentialOperations(catalogNamespace.level(0), metadataObject, restClient);
    }

    public SupportsSchemas asSchemas() throws UnsupportedOperationException {
        return this;
    }

    public SupportsTags supportsTags() throws UnsupportedOperationException {
        return this;
    }

    public SupportsPolicies supportsPolicies() throws UnsupportedOperationException {
        return this;
    }

    public SupportsRoles supportsRoles() throws UnsupportedOperationException {
        return this;
    }

    public String[] listSchemas() throws NoSuchCatalogException {
        EntityListResponse resp = this.restClient.get(BaseSchemaCatalog.formatSchemaRequestPath(this.schemaNamespace()), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.schemaErrorHandler());
        resp.validate();
        return (String[])Arrays.stream(resp.identifiers()).map(NameIdentifier::name).toArray(String[]::new);
    }

    public Schema createSchema(String schemaName, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        SchemaCreateRequest req = new SchemaCreateRequest(schemaName, comment, properties);
        req.validate();
        SchemaResponse resp = this.restClient.post(BaseSchemaCatalog.formatSchemaRequestPath(this.schemaNamespace()), (RESTRequest)req, SchemaResponse.class, Collections.emptyMap(), ErrorHandlers.schemaErrorHandler());
        resp.validate();
        return new GenericSchema(resp.getSchema(), this.restClient, this.catalogNamespace.level(0), this.name());
    }

    public Schema loadSchema(String schemaName) throws NoSuchSchemaException {
        SchemaResponse resp = this.restClient.get(BaseSchemaCatalog.formatSchemaRequestPath(this.schemaNamespace()) + "/" + RESTUtils.encodeString((String)schemaName), SchemaResponse.class, Collections.emptyMap(), ErrorHandlers.schemaErrorHandler());
        resp.validate();
        return new GenericSchema(resp.getSchema(), this.restClient, this.catalogNamespace.level(0), this.name());
    }

    public Schema alterSchema(String schemaName, SchemaChange ... changes) throws NoSuchSchemaException {
        List reqs = Arrays.stream(changes).map(DTOConverters::toSchemaUpdateRequest).collect(Collectors.toList());
        SchemaUpdatesRequest updatesRequest = new SchemaUpdatesRequest(reqs);
        updatesRequest.validate();
        SchemaResponse resp = this.restClient.put(BaseSchemaCatalog.formatSchemaRequestPath(this.schemaNamespace()) + "/" + RESTUtils.encodeString((String)schemaName), (RESTRequest)updatesRequest, SchemaResponse.class, Collections.emptyMap(), ErrorHandlers.schemaErrorHandler());
        resp.validate();
        return new GenericSchema(resp.getSchema(), this.restClient, this.catalogNamespace.level(0), this.name());
    }

    public boolean dropSchema(String schemaName, boolean cascade) throws NonEmptySchemaException {
        DropResponse resp = this.restClient.delete(BaseSchemaCatalog.formatSchemaRequestPath(this.schemaNamespace()) + "/" + RESTUtils.encodeString((String)schemaName), Collections.singletonMap("cascade", String.valueOf(cascade)), DropResponse.class, Collections.emptyMap(), ErrorHandlers.schemaErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    public Tag getTag(String name) {
        return this.objectTagOperations.getTag(name);
    }

    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }

    public String[] listBindingRoleNames() {
        return this.objectRoleOperations.listBindingRoleNames();
    }

    protected Namespace catalogNamespace() {
        return this.catalogNamespace;
    }

    protected Namespace schemaNamespace() {
        return Namespace.of((String[])new String[]{this.catalogNamespace.level(0), this.name()});
    }

    static String formatSchemaRequestPath(Namespace ns) {
        return "api/metalakes/" + RESTUtils.encodeString((String)ns.level(0)) + "/catalogs/" + RESTUtils.encodeString((String)ns.level(1)) + "/schemas";
    }
}

