/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.sink.constraint.BinaryLengthConstraint;
import org.apache.flink.table.runtime.operators.sink.constraint.CharLengthConstraint;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.NestedArrayConstraint;
import org.apache.flink.table.runtime.operators.sink.constraint.NestedMapConstraint;
import org.apache.flink.table.runtime.operators.sink.constraint.NestedRowConstraint;
import org.apache.flink.table.runtime.operators.sink.constraint.NotNullConstraint;
import org.apache.flink.table.runtime.operators.sink.constraint.NotNullEnforcementStrategy;
import org.apache.flink.table.runtime.operators.sink.constraint.TypeLengthEnforcementStrategy;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class ConstraintEnforcerExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Constraint[] constraints;

    private ConstraintEnforcerExecutor(Constraint[] constraints) {
        this.constraints = constraints;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public static Optional<ConstraintEnforcerExecutor> create(RowType physicalType, ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, ExecutionConfigOptions.NestedEnforcer nestedConstraints) {
        Constraint[] topLevelConstraints = ConstraintEnforcerExecutor.createConstraints(physicalType, notNullEnforcer, typeLengthEnforcer, nestedConstraints);
        return ConstraintEnforcerExecutor.create(topLevelConstraints);
    }

    private static Constraint[] createConstraints(RowType physicalType, ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, ExecutionConfigOptions.NestedEnforcer nestedEnforcer) {
        String[] fieldNames = physicalType.getFieldNames().toArray(new String[0]);
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        int[] notNullFieldIndices = ConstraintEnforcerExecutor.getNotNullFieldIndices(physicalType);
        if (notNullFieldIndices.length > 0) {
            String[] notNullFieldNames = (String[])Arrays.stream(notNullFieldIndices).mapToObj(idx -> fieldNames[idx]).toArray(String[]::new);
            constraints.add(new NotNullConstraint(NotNullEnforcementStrategy.of(notNullEnforcer), notNullFieldIndices, notNullFieldNames));
        }
        if (typeLengthEnforcer != ExecutionConfigOptions.TypeLengthEnforcer.IGNORE) {
            ConstraintEnforcerExecutor.addLengthEnforcers(physicalType, typeLengthEnforcer, fieldNames, constraints);
        }
        if (nestedEnforcer != ExecutionConfigOptions.NestedEnforcer.IGNORE) {
            ConstraintEnforcerExecutor.addNestedConstraints(physicalType, notNullEnforcer, typeLengthEnforcer, nestedEnforcer, fieldNames, constraints);
        }
        return (Constraint[])constraints.toArray(Constraint[]::new);
    }

    private static void addNestedConstraints(RowType physicalType, ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, ExecutionConfigOptions.NestedEnforcer nestedEnforcer, String[] fieldNames, List<Constraint> constraints) {
        List<NestedMapInfo> nestedMapInfos;
        List<NestedRowInfo> nestedRowInfo = ConstraintEnforcerExecutor.getNestedRowInfos(physicalType);
        if (!nestedRowInfo.isEmpty()) {
            String[] nestedRowFieldNames = (String[])nestedRowInfo.stream().map(r -> fieldNames[r.getFieldIdx()]).toArray(String[]::new);
            int[] nestedRowFieldIndices = nestedRowInfo.stream().mapToInt(NestedRowInfo::getFieldIdx).toArray();
            int[] nestedRowFieldArities = nestedRowInfo.stream().mapToInt(NestedRowInfo::getArity).toArray();
            Constraint[][] nestedConstraints = (Constraint[][])nestedRowInfo.stream().map(r -> ConstraintEnforcerExecutor.createConstraints(r.getFieldType(), notNullEnforcer, typeLengthEnforcer, nestedEnforcer)).toArray(x$0 -> new Constraint[x$0][]);
            constraints.add(new NestedRowConstraint(nestedRowFieldIndices, nestedRowFieldArities, nestedRowFieldNames, nestedConstraints));
        }
        if (nestedEnforcer == ExecutionConfigOptions.NestedEnforcer.ROWS) {
            return;
        }
        if (typeLengthEnforcer == ExecutionConfigOptions.TypeLengthEnforcer.TRIM_PAD) {
            throw new ValidationException("Trimming and/or padding is not supported if constraint checking is enabled on types nested in collections.");
        }
        List<NestedArrayInfo> nestedArrayInfos = ConstraintEnforcerExecutor.getNestedArrayInfos(physicalType);
        if (!nestedArrayInfos.isEmpty()) {
            String[] nestedRowFieldNames = (String[])nestedArrayInfos.stream().map(r -> fieldNames[r.getFieldIdx()]).toArray(String[]::new);
            int[] nestedRowFieldIndices = nestedArrayInfos.stream().mapToInt(NestedArrayInfo::getFieldIdx).toArray();
            Constraint[][] elementConstraints = (Constraint[][])nestedArrayInfos.stream().map(r1 -> ConstraintEnforcerExecutor.createConstraints(new RowType(List.of(new RowType.RowField("element", r1.getElementType()))), notNullEnforcer, typeLengthEnforcer, nestedEnforcer)).toArray(x$0 -> new Constraint[x$0][]);
            ArrayData.ElementGetter[] elementGetters = (ArrayData.ElementGetter[])nestedArrayInfos.stream().map(r -> ArrayData.createElementGetter((LogicalType)r.getElementType())).toArray(ArrayData.ElementGetter[]::new);
            constraints.add(new NestedArrayConstraint(nestedRowFieldIndices, nestedRowFieldNames, elementConstraints, elementGetters));
        }
        if (!(nestedMapInfos = ConstraintEnforcerExecutor.getNestedMapInfos(physicalType)).isEmpty()) {
            String[] nestedRowFieldNames = (String[])nestedMapInfos.stream().map(r -> fieldNames[r.getFieldIdx()]).toArray(String[]::new);
            int[] nestedRowFieldIndices = nestedMapInfos.stream().mapToInt(NestedMapInfo::getFieldIdx).toArray();
            Constraint[][] elementConstraints = (Constraint[][])nestedMapInfos.stream().map(r1 -> ConstraintEnforcerExecutor.createConstraints(new RowType(List.of(new RowType.RowField("key", r1.getKeyType()), new RowType.RowField("value", r1.getValueType()))), notNullEnforcer, typeLengthEnforcer, nestedEnforcer)).toArray(x$0 -> new Constraint[x$0][]);
            ArrayData.ElementGetter[] keyGetters = (ArrayData.ElementGetter[])nestedMapInfos.stream().map(r -> ArrayData.createElementGetter((LogicalType)r.getKeyType())).toArray(ArrayData.ElementGetter[]::new);
            ArrayData.ElementGetter[] valueGetters = (ArrayData.ElementGetter[])nestedMapInfos.stream().map(r -> ArrayData.createElementGetter((LogicalType)r.getValueType())).toArray(ArrayData.ElementGetter[]::new);
            constraints.add(new NestedMapConstraint(nestedRowFieldIndices, nestedRowFieldNames, elementConstraints, keyGetters, valueGetters));
        }
    }

    private static void addLengthEnforcers(RowType physicalType, ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, String[] fieldNames, List<Constraint> constraints) {
        List<FieldInfo> binaryFieldInfo;
        List<FieldInfo> charFieldInfo = ConstraintEnforcerExecutor.getFieldInfoForLengthEnforcer(physicalType, LengthEnforcerKind.CHAR);
        if (!charFieldInfo.isEmpty()) {
            String[] charFieldNames = (String[])charFieldInfo.stream().map(cfi -> fieldNames[cfi.fieldIdx()]).toArray(String[]::new);
            int[] charFieldIndices = charFieldInfo.stream().mapToInt(FieldInfo::fieldIdx).toArray();
            int[] charFieldLengths = charFieldInfo.stream().mapToInt(FieldInfo::getLength).toArray();
            constraints.add(new CharLengthConstraint(TypeLengthEnforcementStrategy.of(typeLengthEnforcer), charFieldIndices, charFieldLengths, charFieldNames, ConstraintEnforcerExecutor.buildCouldPad(charFieldInfo)));
        }
        if (!(binaryFieldInfo = ConstraintEnforcerExecutor.getFieldInfoForLengthEnforcer(physicalType, LengthEnforcerKind.BINARY)).isEmpty()) {
            String[] binaryFieldNames = (String[])binaryFieldInfo.stream().map(cfi -> fieldNames[cfi.fieldIdx()]).toArray(String[]::new);
            int[] binaryFieldIndices = binaryFieldInfo.stream().mapToInt(FieldInfo::fieldIdx).toArray();
            int[] binaryFieldLengths = binaryFieldInfo.stream().mapToInt(FieldInfo::getLength).toArray();
            constraints.add(new BinaryLengthConstraint(TypeLengthEnforcementStrategy.of(typeLengthEnforcer), binaryFieldIndices, binaryFieldLengths, binaryFieldNames, ConstraintEnforcerExecutor.buildCouldPad(binaryFieldInfo)));
        }
    }

    private static Optional<ConstraintEnforcerExecutor> create(Constraint[] constraints) {
        if (constraints.length == 0) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintEnforcerExecutor(constraints));
    }

    private static int[] getNotNullFieldIndices(RowType physicalType) {
        return IntStream.range(0, physicalType.getFieldCount()).filter(pos -> !physicalType.getTypeAt(pos).isNullable()).toArray();
    }

    private static List<NestedRowInfo> getNestedRowInfos(RowType physicalType) {
        return IntStream.range(0, physicalType.getFieldCount()).boxed().flatMap(pos -> {
            LogicalType nestedType = physicalType.getTypeAt(pos.intValue());
            if (nestedType.is(LogicalTypeRoot.ROW)) {
                RowType rowType = (RowType)nestedType;
                return Stream.of(new NestedRowInfo((int)pos, rowType.getFieldCount(), rowType));
            }
            if (nestedType.is(LogicalTypeRoot.STRUCTURED_TYPE)) {
                StructuredType structuredType = (StructuredType)nestedType;
                List attributes = structuredType.getAttributes();
                List fields = attributes.stream().map(attr -> new RowType.RowField(attr.getName(), attr.getType())).collect(Collectors.toList());
                return Stream.of(new NestedRowInfo((int)pos, attributes.size(), new RowType(structuredType.isNullable(), fields)));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private static List<NestedArrayInfo> getNestedArrayInfos(RowType physicalType) {
        return IntStream.range(0, physicalType.getFieldCount()).boxed().flatMap(pos -> {
            LogicalType nestedType = physicalType.getTypeAt(pos.intValue());
            if (nestedType.is(LogicalTypeRoot.ARRAY)) {
                ArrayType arrayType = (ArrayType)nestedType;
                LogicalType elementType = arrayType.getElementType();
                return Stream.of(new NestedArrayInfo((int)pos, elementType));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private static List<NestedMapInfo> getNestedMapInfos(RowType physicalType) {
        return IntStream.range(0, physicalType.getFieldCount()).boxed().flatMap(pos -> {
            LogicalType nestedType = physicalType.getTypeAt(pos.intValue());
            if (nestedType.is(LogicalTypeRoot.MAP)) {
                MapType mapType = (MapType)nestedType;
                return Stream.of(new NestedMapInfo((int)pos, mapType.getKeyType(), mapType.getValueType()));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private static List<FieldInfo> getFieldInfoForLengthEnforcer(RowType physicalType, LengthEnforcerKind enforcerType) {
        LogicalTypeRoot staticType = null;
        LogicalTypeRoot variableType = null;
        int maxLength = 0;
        switch (enforcerType) {
            case CHAR: {
                staticType = LogicalTypeRoot.CHAR;
                variableType = LogicalTypeRoot.VARCHAR;
                maxLength = Integer.MAX_VALUE;
                break;
            }
            case BINARY: {
                staticType = LogicalTypeRoot.BINARY;
                variableType = LogicalTypeRoot.VARBINARY;
                maxLength = Integer.MAX_VALUE;
            }
        }
        ArrayList<FieldInfo> fieldsAndLengths = new ArrayList<FieldInfo>();
        for (int i = 0; i < physicalType.getFieldCount(); ++i) {
            LogicalType type = physicalType.getTypeAt(i);
            boolean isStatic = type.is(staticType);
            if (isStatic && LogicalTypeChecks.getLength((LogicalType)type) < maxLength || type.is(variableType) && LogicalTypeChecks.getLength((LogicalType)type) < maxLength) {
                fieldsAndLengths.add(new FieldInfo(i, LogicalTypeChecks.getLength((LogicalType)type), isStatic));
                continue;
            }
            if (!isStatic) continue;
            fieldsAndLengths.add(new FieldInfo(i, -1, isStatic));
        }
        return fieldsAndLengths;
    }

    private static BitSet buildCouldPad(List<FieldInfo> charFieldInfo) {
        BitSet couldPad = new BitSet(charFieldInfo.size());
        for (int i = 0; i < charFieldInfo.size(); ++i) {
            if (!charFieldInfo.get(i).couldPad()) continue;
            couldPad.set(i);
        }
        return couldPad;
    }

    @Nullable
    public RowData enforce(RowData row) {
        RowData enforcedRow = row;
        for (Constraint constraint : this.constraints) {
            if ((enforcedRow = constraint.enforce(enforcedRow)) != null) continue;
            return null;
        }
        return enforcedRow;
    }

    static enum LengthEnforcerKind {
        CHAR,
        BINARY;

    }

    @Internal
    private static class FieldInfo {
        private final int fieldIdx;
        private final int length;
        private final boolean couldPad;

        public FieldInfo(int fieldIdx, int length, boolean couldPad) {
            this.fieldIdx = fieldIdx;
            this.length = length;
            this.couldPad = couldPad;
        }

        public int fieldIdx() {
            return this.fieldIdx;
        }

        public boolean couldPad() {
            return this.couldPad;
        }

        public int getLength() {
            return this.length;
        }
    }

    private static class NestedMapInfo {
        private final int fieldIdx;
        private final LogicalType valueType;
        private final LogicalType keyType;

        private NestedMapInfo(int fieldIdx, LogicalType keyType, LogicalType valueType) {
            this.fieldIdx = fieldIdx;
            this.valueType = valueType;
            this.keyType = keyType;
        }

        public int getFieldIdx() {
            return this.fieldIdx;
        }

        public LogicalType getValueType() {
            return this.valueType;
        }

        public LogicalType getKeyType() {
            return this.keyType;
        }
    }

    private static class NestedArrayInfo {
        private final int fieldIdx;
        private final LogicalType elementType;

        private NestedArrayInfo(int fieldIdx, LogicalType elementType) {
            this.fieldIdx = fieldIdx;
            this.elementType = elementType;
        }

        public int getFieldIdx() {
            return this.fieldIdx;
        }

        public LogicalType getElementType() {
            return this.elementType;
        }
    }

    private static class NestedRowInfo {
        private final int fieldIdx;
        private final int arity;
        private final RowType fieldType;

        public NestedRowInfo(int fieldIdx, int arity, RowType fieldType) {
            this.fieldIdx = fieldIdx;
            this.arity = arity;
            this.fieldType = fieldType;
        }

        public int getFieldIdx() {
            return this.fieldIdx;
        }

        public int getArity() {
            return this.arity;
        }

        public RowType getFieldType() {
            return this.fieldType;
        }
    }
}

