/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.Index;
import org.apache.flink.table.utils.EncodingUtils;

@Internal
public class DefaultIndex
implements Index {
    private final String name;
    private final List<String> columns;

    public static DefaultIndex newIndex(String name, List<String> columns) {
        return new DefaultIndex(name, columns);
    }

    private DefaultIndex(String name, List<String> columns) {
        this.name = name;
        this.columns = columns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public String asSummaryString() {
        return String.format("INDEX %s (%s)", EncodingUtils.escapeIdentifier(this.getName()), this.columns.stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")));
    }

    public String toString() {
        return this.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIndex index = (DefaultIndex)o;
        return Objects.equals(this.name, index.name) && Objects.equals(this.columns, index.columns);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.columns);
    }
}

