/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageReadOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

@AutoValue
public abstract class GoogleCloudStorageReadOptions {
    public static final int DEFAULT_BACKOFF_INITIAL_INTERVAL_MILLIS = 200;
    public static final double DEFAULT_BACKOFF_RANDOMIZATION_FACTOR = 0.5;
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    public static final int DEFAULT_BACKOFF_MAX_INTERVAL_MILLIS = 10000;
    public static final int DEFAULT_BACKOFF_MAX_ELAPSED_TIME_MILLIS = 120000;
    public static final boolean DEFAULT_FAST_FAIL_ON_NOT_FOUND = true;
    public static final boolean DEFAULT_SUPPORT_GZIP_ENCODING = true;
    public static final long DEFAULT_INPLACE_SEEK_LIMIT = 0x800000L;
    public static final Fadvise DEFAULT_FADVISE = Fadvise.SEQUENTIAL;
    public static final int DEFAULT_MIN_RANGE_REQUEST_SIZE = 0x200000;
    public static final boolean GRPC_CHECKSUMS_ENABLED_DEFAULT = false;
    public static final long DEFAULT_GRPC_READ_TIMEOUT_MILLIS = 3600000L;
    public static final long DEFAULT_GRPC_READ_METADATA_TIMEOUT_MILLIS = 60000L;
    public static final boolean DEFAULT_GRPC_READ_ZEROCOPY_ENABLED = true;
    public static final long DEFAULT_GRPC_READ_MESSAGE_TIMEOUT_MILLIS = 3000L;
    public static final boolean TRACE_LOGGING_ENABLED_DEFAULT = false;
    public static final GoogleCloudStorageReadOptions DEFAULT = GoogleCloudStorageReadOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageReadOptions.Builder().setBackoffInitialIntervalMillis(200).setBackoffRandomizationFactor(0.5).setBackoffMultiplier(1.5).setBackoffMaxIntervalMillis(10000).setBackoffMaxElapsedTimeMillis(120000).setFastFailOnNotFound(true).setSupportGzipEncoding(true).setInplaceSeekLimit(0x800000L).setFadvise(DEFAULT_FADVISE).setMinRangeRequestSize(0x200000).setGrpcChecksumsEnabled(false).setGrpcReadTimeoutMillis(3600000L).setGrpcReadMetadataTimeoutMillis(60000L).setGrpcReadZeroCopyEnabled(true).setGrpcReadMessageTimeoutMillis(3000L).setTraceLogEnabled(false).setTraceLogTimeThreshold(0L).setTraceLogExcludeProperties(ImmutableSet.of());
    }

    public abstract Builder toBuilder();

    public abstract int getBackoffInitialIntervalMillis();

    public abstract double getBackoffRandomizationFactor();

    public abstract double getBackoffMultiplier();

    public abstract int getBackoffMaxIntervalMillis();

    public abstract int getBackoffMaxElapsedTimeMillis();

    public abstract boolean getFastFailOnNotFound();

    public abstract boolean getSupportGzipEncoding();

    public abstract long getInplaceSeekLimit();

    public abstract Fadvise getFadvise();

    public abstract int getMinRangeRequestSize();

    public abstract boolean isGrpcChecksumsEnabled();

    public abstract long getGrpcReadTimeoutMillis();

    public abstract long getGrpcReadMetadataTimeoutMillis();

    public abstract boolean isGrpcReadZeroCopyEnabled();

    public abstract long getGrpcReadMessageTimeoutMillis();

    public abstract boolean isTraceLogEnabled();

    public abstract ImmutableSet<String> getTraceLogExcludeProperties();

    public abstract long getTraceLogTimeThreshold();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBackoffInitialIntervalMillis(int var1);

        public abstract Builder setBackoffRandomizationFactor(double var1);

        public abstract Builder setBackoffMultiplier(double var1);

        public abstract Builder setBackoffMaxIntervalMillis(int var1);

        public abstract Builder setBackoffMaxElapsedTimeMillis(int var1);

        public abstract Builder setFastFailOnNotFound(boolean var1);

        public abstract Builder setSupportGzipEncoding(boolean var1);

        public abstract Builder setInplaceSeekLimit(long var1);

        public abstract Builder setFadvise(Fadvise var1);

        public abstract Builder setMinRangeRequestSize(int var1);

        public abstract Builder setGrpcChecksumsEnabled(boolean var1);

        public abstract Builder setGrpcReadTimeoutMillis(long var1);

        public abstract Builder setGrpcReadMetadataTimeoutMillis(long var1);

        public abstract Builder setGrpcReadZeroCopyEnabled(boolean var1);

        public abstract Builder setTraceLogEnabled(boolean var1);

        public abstract Builder setTraceLogTimeThreshold(long var1);

        public abstract Builder setTraceLogExcludeProperties(ImmutableSet<String> var1);

        public abstract Builder setGrpcReadMessageTimeoutMillis(long var1);

        abstract GoogleCloudStorageReadOptions autoBuild();

        public GoogleCloudStorageReadOptions build() {
            GoogleCloudStorageReadOptions options = this.autoBuild();
            Preconditions.checkState(options.getInplaceSeekLimit() >= 0L, "inplaceSeekLimit must be non-negative! Got %s", options.getInplaceSeekLimit());
            return options;
        }
    }

    public static enum Fadvise {
        AUTO,
        RANDOM,
        SEQUENTIAL;

    }
}

