/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.TimeoutException;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.platform.commons.util.Preconditions;

class TimeoutExceptionFactory {
    private TimeoutExceptionFactory() {
    }

    static TimeoutException create(String methodSignature, TimeoutDuration timeoutDuration, Throwable failure) {
        String message = String.format("%s timed out after %s", Preconditions.notNull(methodSignature, "method signature must not be null"), Preconditions.notNull(timeoutDuration, "timeout duration must not be null"));
        TimeoutException timeoutException = new TimeoutException(message);
        if (failure != null) {
            timeoutException.addSuppressed(failure);
        }
        return timeoutException;
    }

    static TimeoutException create(String methodSignature, TimeoutDuration timeoutDuration) {
        return TimeoutExceptionFactory.create(methodSignature, timeoutDuration, null);
    }
}

