/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JsonToStringStyleTest
extends AbstractLangTest {
    private final Integer base = 5;

    JsonToStringStyleTest() {
    }

    @BeforeEach
    public void setUp() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    @AfterEach
    public void tearDown() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    void testAppendSuper() {
        Assertions.assertEquals((Object)"{}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "]").toString());
        Assertions.assertEquals((Object)"{}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "  null" + System.lineSeparator() + "]").toString());
        Assertions.assertEquals((Object)"{\"a\":\"hello\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"{\"a\":\"hello\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + System.lineSeparator() + "  null" + System.lineSeparator() + "]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"{\"a\":\"hello\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"{\"a\":\"hello\",\"b\":\"world\"}", (Object)new ToStringBuilder((Object)this.base).appendSuper("{\"a\":\"hello\"}").append("b", (Object)"world").toString());
    }

    @Test
    void testArray() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        Assertions.assertEquals((Object)"{\"name\":\"Jane Doe\",\"age\":25,\"smoker\":true,\"groups\":['admin', 'manager', 'user']}", (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).append("groups", new Object(){

            public String toString() {
                return "['admin', 'manager', 'user']";
            }
        }).toString());
    }

    @Test
    void testArrayEnum() {
        Teacher teacher = new Teacher();
        Hobby[] hobbies = new Hobby[]{Hobby.BOOK, Hobby.SPORT, Hobby.MUSIC};
        teacher.setHobbies(hobbies);
        Assertions.assertEquals((Object)teacher.toString(), (Object)"{\"hobbies\":[\"BOOK\",\"SPORT\",\"MUSIC\"]}");
        teacher.setHobbies(new Hobby[0]);
        Assertions.assertEquals((Object)teacher.toString(), (Object)"{\"hobbies\":[]}");
        teacher.setHobbies(null);
        Assertions.assertEquals((Object)teacher.toString(), (Object)"{\"hobbies\":null}");
    }

    @Test
    void testBlank() {
        Assertions.assertEquals((Object)"{}", (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    void testBooleanArray() {
        boolean[] array = new boolean[]{true, false};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"booleanArray\":[true,false]}", (Object)toStringBuilder.append("booleanArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testByteArray() {
        byte[] array = new byte[]{1, 2, -3, 4};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"byteArray\":[1,2,-3,4]}", (Object)toStringBuilder.append("byteArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testChar() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append('A').toString());
        Assertions.assertEquals((Object)"{\"a\":\"A\"}", (Object)new ToStringBuilder((Object)this.base).append("a", 'A').toString());
        Assertions.assertEquals((Object)"{\"a\":\"A\",\"b\":\"B\"}", (Object)new ToStringBuilder((Object)this.base).append("a", 'A').append("b", 'B').toString());
    }

    @Test
    void testCharArray() {
        char[] array = new char[]{'1', '2', '3', '4'};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"charArray\":[\"1\",\"2\",\"3\",\"4\"]}", (Object)toStringBuilder.append("charArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testCombineListAndEnum() {
        Teacher teacher = new Teacher();
        Hobby[] teacherHobbies = new Hobby[]{Hobby.BOOK, Hobby.SPORT, Hobby.MUSIC};
        teacher.setHobbies(teacherHobbies);
        Student john = new Student();
        john.setHobbies(Arrays.asList(Hobby.BOOK, Hobby.MUSIC));
        Student alice = new Student();
        alice.setHobbies(new ArrayList<Hobby>());
        Student bob = new Student();
        bob.setHobbies(Collections.singletonList(Hobby.BOOK));
        ArrayList<Student> students = new ArrayList<Student>();
        students.add(john);
        students.add(alice);
        students.add(bob);
        AcademyClass academyClass = new AcademyClass();
        academyClass.setStudents(students);
        academyClass.setTeacher(teacher);
        Assertions.assertEquals((Object)academyClass.toString(), (Object)"{\"students\":[{\"hobbies\":[\"BOOK\",\"MUSIC\"]},{\"hobbies\":[]},{\"hobbies\":[\"BOOK\"]}],\"teacher\":{\"hobbies\":[\"BOOK\",\"SPORT\",\"MUSIC\"]}}");
    }

    @Test
    void testDate() {
        Date now = new Date();
        Date afterNow = new Date(System.currentTimeMillis() + 1L);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append((Object)now).toString());
        Assertions.assertEquals((Object)("{\"now\":\"" + now + "\"}"), (Object)new ToStringBuilder((Object)this.base).append("now", (Object)now).toString());
        Assertions.assertEquals((Object)("{\"now\":\"" + now + "\",\"after\":\"" + afterNow + "\"}"), (Object)new ToStringBuilder((Object)this.base).append("now", (Object)now).append("after", (Object)afterNow).toString());
    }

    @Test
    void testDoubleArray() {
        double[] array = new double[]{1.0, 2.0, -3.0, 4.0};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"doubleArray\":[1.0,2.0,-3.0,4.0]}", (Object)toStringBuilder.append("doubleArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testFloatArray() {
        float[] array = new float[]{1.0f, 2.0f, -3.0f, 4.0f};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"floatArray\":[1.0,2.0,-3.0,4.0]}", (Object)toStringBuilder.append("floatArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testIntArray() {
        int[] array = new int[]{1, 2, -3, 4};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"intArray\":[1,2,-3,4]}", (Object)toStringBuilder.append("intArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testLANG1395() {
        Assertions.assertEquals((Object)"{\"name\":\"value\"}", (Object)new ToStringBuilder((Object)this.base).append("name", (Object)"value").toString());
        Assertions.assertEquals((Object)"{\"name\":\"\"}", (Object)new ToStringBuilder((Object)this.base).append("name", (Object)"").toString());
        Assertions.assertEquals((Object)"{\"name\":\"\\\"\"}", (Object)new ToStringBuilder((Object)this.base).append("name", '\"').toString());
        Assertions.assertEquals((Object)"{\"name\":\"\\\\\"}", (Object)new ToStringBuilder((Object)this.base).append("name", '\\').toString());
        Assertions.assertEquals((Object)"{\"name\":\"Let's \\\"quote\\\" this\"}", (Object)new ToStringBuilder((Object)this.base).append("name", (Object)"Let's \"quote\" this").toString());
    }

    @Test
    void testLANG1396() {
        Assertions.assertEquals((Object)"{\"Let's \\\"quote\\\" this\":\"value\"}", (Object)new ToStringBuilder((Object)this.base).append("Let's \"quote\" this", (Object)"value").toString());
    }

    @Test
    void testList() {
        Student student = new Student();
        ArrayList<Hobby> objects = new ArrayList<Hobby>();
        objects.add(Hobby.BOOK);
        objects.add(Hobby.SPORT);
        objects.add(Hobby.MUSIC);
        student.setHobbies(objects);
        Assertions.assertEquals((Object)student.toString(), (Object)"{\"hobbies\":[\"BOOK\",\"SPORT\",\"MUSIC\"]}");
        student.setHobbies(new ArrayList<Hobby>());
        Assertions.assertEquals((Object)student.toString(), (Object)"{\"hobbies\":[]}");
        student.setHobbies(null);
        Assertions.assertEquals((Object)student.toString(), (Object)"{\"hobbies\":null}");
    }

    @Test
    void testLong() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append(3L).toString());
        Assertions.assertEquals((Object)"{\"a\":3}", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assertions.assertEquals((Object)"{\"a\":3,\"b\":4}", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"longArray\":[1,2,-3,4]}", (Object)toStringBuilder.append("longArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testLongArrayArray() {
        long[][] array = new long[][]{{1L, 2L}, null, {5L}};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object[])array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object[])((long[][])null)).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testMapSkipNullKey() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("k1", "v1");
        map.put(null, "v2");
        Assertions.assertEquals((Object)"{\"map\":{\"k1\":\"v1\"}}", (Object)new ToStringBuilder((Object)this.base).append("map", map).toString());
    }

    @Test
    void testNestedMaps() {
        LinkedHashMap<String, String> innerMap = new LinkedHashMap<String, String>();
        innerMap.put("k2.1", "v2.1");
        innerMap.put("k2.2", "v2.2");
        LinkedHashMap<String, Object> baseMap = new LinkedHashMap<String, Object>();
        baseMap.put("k1", "v1");
        baseMap.put("k2", innerMap);
        InnerMapObject object = new InnerMapObject(){

            public String toString() {
                return new ToStringBuilder((Object)this).append("pid", (Object)this.pid).append("map", (Object)this.map).toString();
            }
        };
        object.pid = "dummy-text";
        object.map = baseMap;
        Assertions.assertEquals((Object)"{\"object\":{\"pid\":\"dummy-text\",\"map\":{\"k1\":\"v1\",\"k2\":{\"k2.1\":\"v2.1\",\"k2.2\":\"v2.2\"}}}}", (Object)new ToStringBuilder((Object)this.base).append("object", (Object)object).toString());
    }

    @Test
    void testNestingPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person(){

            public String toString() {
                return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("age", this.age).append("smoker", this.smoker).toString();
            }
        };
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        NestingPerson nestP = new NestingPerson();
        nestP.pid = "#1@Jane";
        nestP.person = p;
        Assertions.assertEquals((Object)"{\"pid\":\"#1@Jane\",\"person\":{\"name\":\"Jane Doe\",\"age\":25,\"smoker\":true}}", (Object)new ToStringBuilder((Object)nestP).append("pid", (Object)nestP.pid).append("person", (Object)nestP.person).toString());
    }

    @Test
    void testNull() {
        Assertions.assertEquals((Object)"null", (Object)new ToStringBuilder(null).toString());
    }

    @Test
    void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append(null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assertions.assertEquals((Object)"{\"a\":null}", (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assertions.assertEquals((Object)"{\"a\":3}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assertions.assertEquals((Object)"{\"a\":3,\"b\":4}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        Assertions.assertEquals((Object)"{\"a\":[]}", (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        Assertions.assertEquals((Object)"{\"a\":{}}", (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        Assertions.assertEquals((Object)"{\"a\":[]}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append("a", (Object)new int[]{1, 2, 3}, false).toString());
        Assertions.assertEquals((Object)"{\"a\":[1,2,3]}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new int[]{1, 2, 3}, true).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ToStringBuilder((Object)this.base).append("a", (Object)new String[]{"v", "x", "y", "z"}, false).toString());
        Assertions.assertEquals((Object)"{\"a\":[\"v\",\"x\",\"y\",\"z\"]}", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[]{"v", "x", "y", "z"}, true).toString());
    }

    @Test
    void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"objectArray\":[null,5,[3,6]]}", (Object)toStringBuilder.append("objectArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    @Test
    void testObjectWithInnerMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("k1", "value1");
        map.put("k2", 2);
        InnerMapObject object = new InnerMapObject(){

            public String toString() {
                return new ToStringBuilder((Object)this).append("pid", (Object)this.pid).append("map", (Object)this.map).toString();
            }
        };
        object.pid = "dummy-text";
        object.map = map;
        Assertions.assertEquals((Object)"{\"object\":{\"pid\":\"dummy-text\",\"map\":{\"k1\":\"value1\",\"k2\":2}}}", (Object)new ToStringBuilder((Object)this.base).append("object", (Object)object).toString());
    }

    @Test
    void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        Assertions.assertEquals((Object)"{\"name\":\"Jane Doe\",\"age\":25,\"smoker\":true}", (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    @Test
    void testRootMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("k1", "v1");
        map.put("k2", 2);
        Assertions.assertEquals((Object)"{\"map\":{\"k1\":\"v1\",\"k2\":2}}", (Object)new ToStringBuilder((Object)this.base).append("map", map).toString());
    }

    @Test
    void testShortArray() {
        short[] array = new short[]{1, 2, -3, 4};
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this.base);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append(array).toString());
        Assertions.assertEquals((Object)"{\"shortArray\":[1,2,-3,4]}", (Object)toStringBuilder.append("shortArray", array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((long[])null).toString());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> toStringBuilder.append((Object)array).toString());
    }

    static class Teacher {
        Hobby[] hobbies;

        Teacher() {
        }

        public Hobby[] getHobbies() {
            return this.hobbies;
        }

        public void setHobbies(Hobby[] hobbies) {
            this.hobbies = hobbies;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static enum Hobby {
        SPORT,
        BOOK,
        MUSIC;

    }

    static class Student {
        List<Hobby> hobbies;

        Student() {
        }

        public List<Hobby> getHobbies() {
            return this.hobbies;
        }

        public void setHobbies(List<Hobby> hobbies) {
            this.hobbies = hobbies;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class AcademyClass {
        Teacher teacher;
        List<Student> students;

        AcademyClass() {
        }

        public List<Student> getStudents() {
            return this.students;
        }

        public Teacher getTeacher() {
            return this.teacher;
        }

        public void setStudents(List<Student> students) {
            this.students = students;
        }

        public void setTeacher(Teacher teacher) {
            this.teacher = teacher;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    static class InnerMapObject {
        String pid;
        Map<String, Object> map;

        InnerMapObject() {
        }
    }

    static class NestingPerson {
        String pid;
        ToStringStyleTest.Person person;

        NestingPerson() {
        }
    }

    static final class EmptyEnum
    extends Enum<EmptyEnum> {
        private static final /* synthetic */ EmptyEnum[] $VALUES;

        public static EmptyEnum[] values() {
            return (EmptyEnum[])$VALUES.clone();
        }

        public static EmptyEnum valueOf(String name) {
            return Enum.valueOf(EmptyEnum.class, name);
        }

        private static /* synthetic */ EmptyEnum[] $values() {
            return new EmptyEnum[0];
        }

        static {
            $VALUES = EmptyEnum.$values();
        }
    }
}

