/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.exception.CustomCheckedException;
import org.apache.commons.lang3.exception.CustomUncheckedException;
import org.apache.commons.lang3.function.AnnotationTestFixture;

class MethodFixtures
extends AbstractLangTest {
    static MethodFixtures INSTANCE = new MethodFixtures();
    private String value1;
    private String value2;
    private String[] valueArray;

    MethodFixtures() {
    }

    static Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return MethodFixtures.class.getDeclaredMethod(name, parameterTypes);
    }

    static Method getMethodForGetString() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getString", new Class[0]);
    }

    static Method getMethodForGetString1Arg() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getString1Arg", String.class);
    }

    static Method getMethodForGetString1ArgChecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getString1ArgChecked", String.class);
    }

    static Method getMethodForGetString1ArgThrowsChecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getString1ArgThrowsChecked", String.class);
    }

    static Method getMethodForGetString1ArgThrowsUnchecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getString1ArgThrowsUnchecked", String.class);
    }

    static Method getMethodForGetString2Arg() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getString2Args", String.class, String.class);
    }

    static Method getMethodForGetStringChecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getStringChecked", new Class[0]);
    }

    static Method getMethodForGetStringsVarArg() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getStringArrayVarStringArgs", String[].class);
    }

    static Method getMethodForGetStringThrowsChecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getStringThrowsChecked", new Class[0]);
    }

    static Method getMethodForGetStringThrowsUnchecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("getStringThrowsUnchecked", new Class[0]);
    }

    static Method getMethodForGetStringVarStringArgs() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("geStringtVarStringArgs", String[].class);
    }

    static Method getMethodForSetString1Arg() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("setValue1", String.class);
    }

    static Method getMethodForSetString1ArgThrows() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("setValue1Throws", String.class);
    }

    static Method getMethodForSetString1ArgThrowsChecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("setValue1ThrowsChecked", String.class);
    }

    static Method getMethodForSetString1ArgThrowsUnchecked() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("setValue1ThrowsUnchecked", String.class);
    }

    static Method getMethodForSetString2Args() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("setValue1And2", String.class, String.class);
    }

    static Method getMethodForSetStringsVarArg() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("setValueArray", String[].class);
    }

    static Method getMethodForStaticGetString() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("staticGetString", new Class[0]);
    }

    static Method getMethodForVoidMethod() throws NoSuchMethodException, SecurityException {
        return MethodFixtures.getDeclaredMethod("voidMethod", new Class[0]);
    }

    public static String staticGetString() {
        return "Static.ABC";
    }

    public String geStringtVarStringArgs(String ... strings) {
        return "XYZ";
    }

    @AnnotationTestFixture
    public String getString() {
        return "ABC";
    }

    public String getString1Arg(String value) {
        return value;
    }

    public String getString1ArgChecked(String value) throws IOException {
        return value;
    }

    public String getString1ArgThrowsChecked(String value) throws CustomCheckedException {
        throw new CustomCheckedException("getString1ArgThrowsChecked");
    }

    public String getString1ArgThrowsUnchecked(String value) {
        throw new CustomUncheckedException("getString1ArgThrowsUnchecked");
    }

    @AnnotationTestFixture
    public String getString2() {
        return "EFG";
    }

    public String getString2Args(String value1, String value2) {
        return value1 + value2;
    }

    public String[] getStringArrayVarStringArgs(String ... strings) {
        return strings;
    }

    public String getStringChecked() throws Exception {
        return "ABC";
    }

    public String getStringThrowsChecked() throws CustomCheckedException {
        throw new CustomCheckedException("getStringThrowsChecked");
    }

    public String getStringThrowsUnchecked() {
        throw new CustomUncheckedException("getStringThrowsUnchecked");
    }

    String getValue1() {
        return this.value1;
    }

    String getValue2() {
        return this.value2;
    }

    String[] getValueArray() {
        return this.valueArray;
    }

    void setValue1(String value1) throws Exception {
        this.value1 = value1;
    }

    void setValue1And2(String value1, String value2) throws Exception {
        this.value1 = value1;
        this.value2 = value2;
    }

    void setValue1ThrowsChecked(String value1) throws CustomCheckedException {
        throw new CustomCheckedException("setValue1ThrowsChecked");
    }

    void setValue1ThrowsUnchecked(String value1) {
        throw new CustomUncheckedException("setValue1ThrowsUnchecked");
    }

    void setValue2(String value2) {
        this.value2 = value2;
    }

    void setValueArray(String ... values) throws Exception {
        this.valueArray = values;
    }

    public void voidMethod() {
    }
}

