/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.stress.generate.Distribution;

public class DistributionSequence
extends Distribution {
    private final long start;
    private final long totalCount;
    private final AtomicLong next = new AtomicLong();

    public DistributionSequence(long start, long end) {
        if (start > end) {
            throw new IllegalStateException();
        }
        this.start = start;
        this.totalCount = 1L + end - start;
    }

    private long nextWithWrap() {
        long next = this.next.getAndIncrement();
        return this.start + next % this.totalCount;
    }

    @Override
    public long next() {
        return this.nextWithWrap();
    }

    @Override
    public double nextDouble() {
        return this.nextWithWrap();
    }

    @Override
    public long inverseCumProb(double cumProb) {
        return (long)((double)this.start + (double)(this.totalCount - 1L) * cumProb);
    }

    @Override
    public void setSeed(long seed) {
        this.next.set(seed);
    }
}

