/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.jute.Record;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;

public class TestableZooKeeper
extends ZooKeeperAdmin {
    public TestableZooKeeper(String host, int sessionTimeout, Watcher watcher) throws IOException {
        super(host, sessionTimeout, watcher);
    }

    public void setXid(int xid) {
        this.cnxn.xid = xid;
    }

    public int checkXid() {
        return this.cnxn.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testableConnloss() throws IOException {
        ClientCnxn clientCnxn = this.cnxn;
        synchronized (clientCnxn) {
            this.cnxn.sendThread.testableCloseSocket();
        }
    }

    public boolean pauseCnxn(final long ms) {
        final CountDownLatch initiatedPause = new CountDownLatch(1);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClientCnxn clientCnxn = TestableZooKeeper.this.cnxn;
                synchronized (clientCnxn) {
                    try {
                        try {
                            TestableZooKeeper.this.cnxn.sendThread.testableCloseSocket();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            initiatedPause.countDown();
                        }
                        Thread.sleep(ms);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }.start();
        try {
            return initiatedPause.await(ms, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public SocketAddress testableLocalSocketAddress() {
        return super.testableLocalSocketAddress();
    }

    public SocketAddress testableRemoteSocketAddress() {
        return super.testableRemoteSocketAddress();
    }

    public long testableLastZxid() {
        return this.cnxn.getLastZxid();
    }

    public ReplyHeader submitRequest(RequestHeader h, Record request, Record response, ZooKeeper.WatchRegistration watchRegistration) throws InterruptedException {
        return this.cnxn.submitRequest(h, request, response, watchRegistration);
    }

    public void disconnect() {
        this.cnxn.disconnect();
    }
}

