/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.DbAttributes;

public final class DbClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, DbClientAttributesGetter<REQUEST, RESPONSE>> {
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey((String)"db.statement");
    static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey((String)"db.operation");

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new DbClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    DbClientAttributesExtractor(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        super(getter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_QUERY_TEXT, (Object)((DbClientAttributesGetter)this.getter).getDbQueryText(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_OPERATION_NAME, (Object)((DbClientAttributesGetter)this.getter).getDbOperationName(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_QUERY_SUMMARY, (Object)((DbClientAttributesGetter)this.getter).getDbQuerySummary(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_STATEMENT, (Object)((DbClientAttributesGetter)this.getter).getDbQueryText(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)((DbClientAttributesGetter)this.getter).getDbOperationName(request));
        }
    }
}

