/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import com.beust.jcommander.Parameter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.RateLimiter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.Unpooled;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.perf.utils.PaddingDecimalFormat;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfWriter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PerfWriter.class);
    private final LongAdder recordsWritten = new LongAdder();
    private final LongAdder bytesWritten = new LongAdder();
    private final byte[] payload;
    private final ServiceURI serviceURI;
    private final Flags flags;
    private final Recorder recorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    private final Recorder cumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private static final DecimalFormat throughputFormat = new PaddingDecimalFormat("0.0", 8);
    private static final DecimalFormat dec = new PaddingDecimalFormat("0.000", 7);

    PerfWriter(ServiceURI serviceURI, Flags flags) {
        this.serviceURI = serviceURI;
        this.flags = flags;
        this.payload = new byte[flags.recordSize];
        ThreadLocalRandom.current().nextBytes(this.payload);
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            log.error("Encountered exception at running dlog perf writer", (Throwable)e);
        }
    }

    void execute() throws Exception {
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting dlog perf writer with config : {}", (Object)w.writeValueAsString((Object)this.flags));
        DistributedLogConfiguration conf = PerfWriter.newDlogConf(this.flags);
        try (Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(this.serviceURI.getUri()).build();){
            this.execute(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Namespace namespace) throws Exception {
        ArrayList<Pair> managers = new ArrayList<Pair>(this.flags.numLogs);
        for (int i = 0; i < this.flags.numLogs; ++i) {
            String logName = String.format(this.flags.logName, i);
            managers.add(Pair.of((Object)i, (Object)namespace.openLog(logName)));
        }
        log.info("Successfully open {} logs", (Object)managers.size());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.isDone.set(true);
            PerfWriter.printAggregatedStats(this.cumulativeRecorder);
        }));
        ExecutorService executor = Executors.newFixedThreadPool(this.flags.numThreads);
        try {
            int i = 0;
            while (i < this.flags.numThreads) {
                int idx = i++;
                List logsThisThread = managers.stream().filter(pair -> (Integer)pair.getLeft() % this.flags.numThreads == idx).map(pair -> (DistributedLogManager)pair.getRight()).collect(Collectors.toList());
                long numRecordsForThisThread = this.flags.numRecords / (long)this.flags.numThreads;
                long numBytesForThisThread = this.flags.numBytes / (long)this.flags.numThreads;
                double writeRateForThisThread = (double)this.flags.writeRate / (double)this.flags.numThreads;
                long maxOutstandingBytesForThisThread = this.flags.maxOutstandingMB * 1024L * 1024L / (long)this.flags.numThreads;
                executor.submit(() -> {
                    try {
                        this.write(logsThisThread, writeRateForThisThread, (int)maxOutstandingBytesForThisThread, numRecordsForThisThread, numBytesForThisThread);
                    }
                    catch (Exception e) {
                        log.error("Encountered error at writing records", (Throwable)e);
                    }
                });
            }
            log.info("Started {} write threads", (Object)this.flags.numThreads);
            this.reportStats();
        }
        finally {
            executor.shutdown();
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
            managers.forEach(manager -> ((DistributedLogManager)manager.getRight()).asyncClose());
        }
    }

    void write(List<DistributedLogManager> logs, double writeRate, int maxOutstandingBytesForThisThread, long numRecordsForThisThread, long numBytesForThisThread) throws Exception {
        log.info("Write thread started with : logs = {}, rate = {}, num records = {}, num bytes = {}, max outstanding bytes = {}", new Object[]{logs.stream().map(l -> l.getStreamName()).collect(Collectors.toList()), writeRate, numRecordsForThisThread, numBytesForThisThread, maxOutstandingBytesForThisThread});
        List writerFutures = logs.stream().map(manager -> manager.openAsyncLogWriter()).collect(Collectors.toList());
        List writers = (List)FutureUtils.result((CompletableFuture)FutureUtils.collect(writerFutures));
        long txid = writers.stream().mapToLong(writer -> writer.getLastTxId()).max().orElse(0L);
        txid = Math.max(0L, txid);
        RateLimiter limiter = writeRate > 0.0 ? RateLimiter.create((double)writeRate) : null;
        Semaphore semaphore = maxOutstandingBytesForThisThread > 0 ? new Semaphore(maxOutstandingBytesForThisThread) : null;
        if (limiter != null) {
            limiter.acquire((int)writeRate);
        }
        long totalWritten = 0L;
        long totalBytesWritten = 0L;
        int numLogs = logs.size();
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= numLogs) continue block0;
                if (numRecordsForThisThread > 0L && totalWritten >= numRecordsForThisThread) {
                    this.markPerfDone();
                }
                if (numBytesForThisThread > 0L && totalBytesWritten >= numBytesForThisThread) {
                    this.markPerfDone();
                }
                if (null != semaphore) {
                    semaphore.acquire(this.payload.length);
                }
                ++totalWritten;
                totalBytesWritten += (long)this.payload.length;
                if (null != limiter) {
                    limiter.acquire(this.payload.length);
                }
                long sendTime = System.nanoTime();
                ((CompletableFuture)((AsyncLogWriter)writers.get(i)).write(new LogRecord(++txid, Unpooled.wrappedBuffer((byte[])this.payload))).thenAccept(dlsn -> {
                    if (null != semaphore) {
                        semaphore.release(this.payload.length);
                    }
                    this.recordsWritten.increment();
                    this.bytesWritten.add(this.payload.length);
                    long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sendTime);
                    this.recorder.recordValue(latencyMicros);
                    this.cumulativeRecorder.recordValue(latencyMicros);
                })).exceptionally(cause -> {
                    log.warn("Error at writing records", cause);
                    System.exit(-1);
                    return null;
                });
                ++i;
            }
            break;
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    void markPerfDone() throws Exception {
        log.info("------------------- DONE -----------------------");
        PerfWriter.printAggregatedStats(this.cumulativeRecorder);
        this.isDone.set(true);
        Thread.sleep(5000L);
        System.exit(0);
    }

    void reportStats() {
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.isDone.get()) break;
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            double rate = (double)this.recordsWritten.sumThenReset() / elapsed;
            double throughput = (double)this.bytesWritten.sumThenReset() / elapsed / 1024.0 / 1024.0;
            reportHistogram = this.recorder.getIntervalHistogram(reportHistogram);
            log.info("Throughput written : {}  records/s --- {} MB/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{throughputFormat.format(rate), throughputFormat.format(throughput), dec.format(reportHistogram.getMean() / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportHistogram.getMaxValue() / 1000.0)});
            reportHistogram.reset();
            oldTime = now;
        }
    }

    private static DistributedLogConfiguration newDlogConf(Flags flags) {
        return new DistributedLogConfiguration().setEnsembleSize(flags.ensembleSize).setWriteQuorumSize(flags.writeQuorumSize).setAckQuorumSize(flags.ackQuorumSize).setOutputBufferSize(524288).setPeriodicFlushFrequencyMilliSeconds(2).setWriteLockEnabled(false).setMaxLogSegmentBytes((long)flags.maxLogSegmentSize).setLogSegmentRollingIntervalMinutes(1).setExplicitTruncationByApplication(true);
    }

    private static void printAggregatedStats(Recorder recorder) {
        Histogram reportHistogram = recorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportHistogram.getMean() / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.999) / 1000.0), dec.format((double)reportHistogram.getMaxValue() / 1000.0)});
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-r", "--rate"}, description="Write rate bytes/s across log streams")
        public int writeRate = 0;
        @Parameter(names={"-rs", "--record-size"}, description="Log record size")
        public int recordSize = 1024;
        @Parameter(names={"-ln", "--log-name"}, description="Log name or log name pattern if more than 1 log is specified at `--num-logs`")
        public String logName = "test-log-%06d";
        @Parameter(names={"-l", "--num-logs"}, description="Number of log streams")
        public int numLogs = 1;
        @Parameter(names={"-t", "--threads"}, description="Number of threads writing")
        public int numThreads = 1;
        @Parameter(names={"-mob", "--max-outstanding-megabytes"}, description="Number of threads writing")
        public long maxOutstandingMB = 200L;
        @Parameter(names={"-n", "--num-records"}, description="Number of records to write in total. If 0, it will keep writing")
        public long numRecords = 0L;
        @Parameter(names={"-mlss", "--max-log-segment-size"}, description="Max log segment size")
        public int maxLogSegmentSize = 0x4000000;
        @Parameter(names={"-b", "--num-bytes"}, description="Number of bytes to write in total. If 0, it will keep writing")
        public long numBytes = 0L;
        @Parameter(names={"-e", "--ensemble-size"}, description="Ledger ensemble size")
        public int ensembleSize = 1;
        @Parameter(names={"-w", "--write-quorum-size"}, description="Ledger write quorum size")
        public int writeQuorumSize = 1;
        @Parameter(names={"-a", "--ack-quorum-size"}, description="Ledger ack quorum size")
        public int ackQuorumSize = 1;
    }
}

