/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlFactories {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFactories.class);

    private XmlFactories() {
    }

    public static DocumentBuilderFactory getSafeDocumentBuilderFactory() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        XmlFactories.trySetFeature(builderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XmlFactories.trySetFeature(builderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        XmlFactories.trySetFeature(builderFactory, "http://xml.org/sax/features/external-general-entities", false);
        XmlFactories.trySetFeature(builderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        XmlFactories.trySetFeature(builderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return builderFactory;
    }

    public static TransformerFactory getSafeTransformFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        XmlFactories.trySetFeature(transformerFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }

    private static void trySetFeature(DocumentBuilderFactory factory, String name, boolean value) {
        try {
            factory.setFeature(name, value);
        }
        catch (ParserConfigurationException e) {
            LOG.warn("Error setting document builder factory feature", e);
        }
    }

    private static void trySetFeature(TransformerFactory factory, String name, boolean value) {
        try {
            factory.setFeature(name, value);
        }
        catch (TransformerConfigurationException e) {
            LOG.warn("Error setting transformer factory feature", e);
        }
    }
}

