/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.JBButil;
import spec.jbb.Orderline;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;

public class Order {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private Customer customerPtr;
    private Orderline[] orderlineList;
    private BigDecimal totalAmount;
    private BigDecimal customerDiscountRate;
    private BigDecimal districtTax;
    private BigDecimal warehouseTax;
    private Date entryDateTime;
    private int orderId;
    private short customerId;
    private short carrierId;
    private short orderLineCount;
    private byte districtId;
    private short warehouseId;
    private boolean allLocal;

    public Order(Company company, int n, byte by, short s, short s2, Customer customer, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        this.initOrder(company, n, by, s, s2, customer, bigDecimal, bigDecimal2, bigDecimal3);
    }

    public void initOrder(Company company, int n, byte by, short s, short s2, Customer customer, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        this.company = company;
        this.orderId = n;
        this.districtId = by;
        this.warehouseId = s;
        this.customerId = s2;
        this.customerPtr = customer;
        this.orderLineCount = 0;
        this.orderlineList = new Orderline[Transaction.aveOrderlines + 10];
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            JBButil.getLog().finest("Order::initOrder  orderlineList=" + this.orderlineList);
        }
        this.entryDateTime = new Date();
        this.carrierId = 0;
        this.allLocal = true;
        this.districtTax = bigDecimal;
        this.warehouseTax = bigDecimal2;
        this.customerDiscountRate = bigDecimal3;
    }

    public synchronized boolean processLines(Warehouse warehouse, short s, boolean bl) {
        boolean bl2 = true;
        BigDecimal bigDecimal = BigDecimal.valueOf(0L, 2);
        for (short s2 = 1; s2 <= s; s2 = (short)(s2 + 1)) {
            Orderline orderline = new Orderline(this.company, this.orderId, this.districtId, this.warehouseId, s2, s, bl);
            short s3 = this.warehouseId;
            if (JBButil.random(1, 100, this.warehouseId) == 1 && this.company.getMaxWarehouses() > 1) {
                while (s3 == this.warehouseId) {
                    s3 = (short)JBButil.random(1, (int)this.company.getMaxWarehouses(), this.warehouseId);
                }
                this.allLocal = false;
            }
            orderline.setSupplyWarehouse(s3);
            if (orderline.validateAndProcess(warehouse)) {
                bigDecimal = bigDecimal.add(orderline.getAmount());
                this.orderlineList[this.orderLineCount] = orderline;
                this.orderLineCount = (short)(this.orderLineCount + 1);
                continue;
            }
            bl2 = false;
        }
        BigDecimal bigDecimal2 = bigDecimal.multiply(BigDecimal.valueOf(1L, 0).subtract(this.customerDiscountRate)).setScale(2, 4);
        this.totalAmount = bigDecimal2.multiply(BigDecimal.valueOf(1L, 0).add(this.warehouseTax).add(this.districtTax)).setScale(2, 4);
        return bl2;
    }

    public synchronized void dateOrderlines(Date date) {
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            JBButil.getLog().finest("Order::dateOrderlines  orderlineList=" + this.orderlineList + " orderlineCount=" + this.orderLineCount);
        }
        for (int i = 0; i < this.orderLineCount; ++i) {
            Orderline orderline = this.orderlineList[i];
            if (JBButil.getLog().isLoggable(Level.FINEST)) {
                JBButil.getLog().finest(" orderline=" + orderline + " orderline#=" + i);
            }
            orderline.setDeliveryTime(date);
        }
    }

    public synchronized int getId() {
        int n = this.orderId;
        return n;
    }

    public synchronized Customer getCustomerPtr() {
        Customer customer = this.customerPtr;
        return customer;
    }

    public synchronized BigDecimal getTotalAmount() {
        BigDecimal bigDecimal = this.totalAmount;
        return bigDecimal;
    }

    public synchronized Date getEntryTime() {
        Date date = this.entryDateTime;
        return date;
    }

    public synchronized void setCarrierId(short s) {
        this.carrierId = s;
    }

    public synchronized short getCarrierId() {
        short s = this.carrierId;
        return s;
    }

    public synchronized Orderline[] getOrderlineList() {
        if (JBButil.getLog().isLoggable(Level.FINEST)) {
            JBButil.getLog().finest("Order::getOrderlineList  orderlineList=" + this.orderlineList);
        }
        return this.orderlineList;
    }

    public synchronized short getOrderlineCount() {
        short s = this.orderLineCount;
        return s;
    }

    public synchronized void setAllLocal(boolean bl) {
        this.allLocal = bl;
    }

    public synchronized void setEntryDateTime(Date date) {
        this.entryDateTime = date;
    }
}

