#!/bin/sh

# This is a buildscript for a cross mingwin compiler.
# You should be able to just run it once you set
# the correct src, build, and install dirs

#SRCDIR=${HOME}/project/Xmingwin
#BUILDDIR=${HOME}/project/build/Xmingwin
#PREFIX=${HOME}/project/install/Xmingwin

SRCDIR=/opt/mingw/src
BUILDDIR=/opt/mingw/build
PREFIX=/opt/mingw

#TARGET=i386-pc-mingw32
# Mumit suggested changing this target name to i386-mingw32msvc
TARGET=i386-mingw32msvc
TARGET_ALIAS=i386-mingw32msvc

# The install location's bin dir must be on the path
PATH=$PREFIX/bin:$PATH

BASE_URL=ftp://ftp.xraylith.wisc.edu/pub/khan/gnu-win32/mingw32/snapshots/gcc-2.95.2-1
BINUTILS=binutils-19990818
BINUTILS_TAR=${BINUTILS}-1-src.tar.gz
GCC=gcc-2.95.2
GCC_TAR=${GCC}-1-src.tar.gz
MINGWSRC_ZIP=mingw-20000203.zip
MSVCRT_ZIP=mingw-msvcrt-20000203.zip


# If the files are not in the src directory, download them now
mkdir -p $SRCDIR
cd $SRCDIR

for f in $BINUTILS_TAR $GCC_TAR $MINGWSRC_ZIP $MSVCRT_ZIP; do
  if test ! -f ${f} ; then
    echo "wget ${BASE_URL}/${f}"
    wget ${BASE_URL}/${f}
    if test ! -f ${f} ; then
      echo "Could not download ${BASE_URL}/${f}"
      exit 1
    fi
  else
    echo "Found ${f} in the srcdir $SRCDIR"
  fi
done



echo "--- install binary cross libs and includes"
mkdir -p $PREFIX
cd $PREFIX
if test ! -d $TARGET_ALIAS ; then
  unzip -o $SRCDIR/$MSVCRT_ZIP
fi
if test ! -d $TARGET_ALIAS ; then
  echo "error extracting $MSVCRT_ZIP, target alias dir $SRCDIR/$TARGET_ALIAS not found"
  exit 1
fi
if test $TARGET_ALIAS != $TARGET ; then
  ln -s $TARGET_ALIAS $TARGET 
fi


echo "--- compile and install binutils"
cd $SRCDIR
if test ! -d $BINUTILS ; then
  echo "extracting $BINUTILS_TAR in $SRCDIR"
  tar -xzf $BINUTILS_TAR
  if test ! -d $BINUTILS ; then
    echo "error extracting $BINUTILS_TAR, could not find $SRCDIR/$BINUTILS dir"
    exit 1
  fi
fi
mkdir -p $BUILDDIR/binutils-$TARGET
cd $BUILDDIR/binutils-$TARGET
if test ! -f Makefile ; then
  echo "running ./configure for binutils, output saved in configure.log"
  $SRCDIR/$BINUTILS/configure -v --prefix=$PREFIX --target=$TARGET \
    &> configure.log
fi

echo "running \"make\" for binutils, output saved in make.log"
make all &> make.log
echo "running \"make install\" for binutils, output saved in make_install.log"
make install &> make_install.log

echo "--- compile and install gcc"
cd $SRCDIR
if test ! -d $GCC ; then
  echo "extracting $GCC_TAR in $SRCDIR"
  tar -xzf $GCC_TAR
  if test ! -d $GCC ; then
    echo "error extracting $GCC_TAR, could not find $SRCDIR/$GCC dir"
    exit 1
  fi
fi
mkdir -p $BUILDDIR/gcc-$TARGET
cd $BUILDDIR/gcc-$TARGET
if test ! -f Makefile ; then
  echo "running ./configure for gcc, output saved in configure.log"
  $SRCDIR/$GCC/configure -v --prefix=$PREFIX --target=$TARGET \
           --with-gnu-as --with-gnu-ld \
           &> configure.log
fi

# work around gcc bug?
#cd gcc ; make installdirs ; cd -

#echo "running \"make cross\" for gcc, output saved in make.log"
echo "running \"make\" for gcc, output saved in make.log"
#NOTE: We seem to need to run make cross not make all here
#make cross &> make.log
#FIXME: we seem to need to run make 2 times, not sure where the bug is.
make all &> make1.log
make all &> make2.log
echo "running \"make install\" for gcc, output saved in make_install.log"
make install &> make_install.log

echo "Done!"
echo ""
echo "Your mingwin cross compilers are installed in $PREFIX"
echo "The c++ compiler is called $TARGET-c++ or $TARGET-g++"
echo "The c compiler is called $TARGET-gcc"
echo "You may need to add $PREFIX/bin to your PATH"

