
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BothValuePlotMethodAttributes.h
    \\brief Definition of BothValuePlotMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "BothValuePlotMethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

BothValuePlotMethodAttributes::BothValuePlotMethodAttributes():
	marker_height_(ParameterManager::getDouble("contour_grid_value_marker_height")),
	marker_quality_(ParameterManager::getString("contour_grid_value_marker_qual")),
	marker_index_(ParameterManager::getInt("contour_grid_value_marker_index")),
	position_(ParameterManager::getString("contour_grid_value_position"))
	,
	marker_colour_(MagTranslator<string, Colour>().magics("contour_grid_value_marker_colour"))
	
{
}


BothValuePlotMethodAttributes::~BothValuePlotMethodAttributes()
{

}


void BothValuePlotMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour_grid_value";
	prefix[i++] = "contour_grid_value";
	
	setAttribute(prefix, "contour_grid_value_marker_height", marker_height_, params);
	setAttribute(prefix, "contour_grid_value_marker_qual", marker_quality_, params);
	setAttribute(prefix, "contour_grid_value_marker_index", marker_index_, params);
	setAttribute(prefix, "contour_grid_value_position", position_, params);
	
	setMember(prefix, "contour_grid_value_marker_colour", marker_colour_, params);
	
}

void BothValuePlotMethodAttributes::copy(const BothValuePlotMethodAttributes& other)
{
	marker_height_ = other.marker_height_;
	marker_quality_ = other.marker_quality_;
	marker_index_ = other.marker_index_;
	position_ = other.position_;
	marker_colour_ = unique_ptr<Colour>(other.marker_colour_->clone());
	
}


bool BothValuePlotMethodAttributes::accept(const string& node)
{

	if ( magCompare(node, "both")  )
		return true;
	
	return false;
}

void BothValuePlotMethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "both")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void BothValuePlotMethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " marker_height = " <<  marker_height_;
	out << " marker_quality = " <<  marker_quality_;
	out << " marker_index = " <<  marker_index_;
	out << " position = " <<  position_;
	out << " marker_colour = " <<  *marker_colour_;
	
	out << "]" << "\n";
}

void BothValuePlotMethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"both\"";
	out << ", \"contour_grid_value_marker_height\":";
	niceprint(out,marker_height_);
	out << ", \"contour_grid_value_marker_qual\":";
	niceprint(out,marker_quality_);
	out << ", \"contour_grid_value_marker_index\":";
	niceprint(out,marker_index_);
	out << ", \"contour_grid_value_position\":";
	niceprint(out,position_);
	out << ", \"contour_grid_value_marker_colour\":";
	niceprint(out, *marker_colour_);
	
}

static MagicsParameter<double> contour_grid_value_marker_height("contour_grid_value_marker_height", 0.25);
static MagicsParameter<string> contour_grid_value_marker_qual("contour_grid_value_marker_qual", "low");
static MagicsParameter<int> contour_grid_value_marker_index("contour_grid_value_marker_index", 3);
static MagicsParameter<string> contour_grid_value_position("contour_grid_value_position", "top");
static MagicsParameter<string> contour_grid_value_marker_colour("contour_grid_value_marker_colour", "red");
