/* test-vfs-volume.c generated by valac 0.10.4, the Vala compiler
 * generated from test-vfs-volume.vala, do not modify */

/*
 * Test program for the Volume VFS backends.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/vfs.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST_VOLUME (test_volume_get_type ())
#define TEST_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_VOLUME, TestVolume))
#define TEST_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_VOLUME, TestVolumeClass))
#define IS_TEST_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_VOLUME))
#define IS_TEST_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_VOLUME))
#define TEST_VOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_VOLUME, TestVolumeClass))

typedef struct _TestVolume TestVolume;
typedef struct _TestVolumeClass TestVolumeClass;
typedef struct _TestVolumePrivate TestVolumePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecTestVolume ParamSpecTestVolume;

struct _TestVolume {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestVolumePrivate * priv;
};

struct _TestVolumeClass {
	GTypeClass parent_class;
	void (*finalize) (TestVolume *self);
};

struct _ParamSpecTestVolume {
	GParamSpec parent_instance;
};


static gpointer test_volume_parent_class = NULL;

gpointer test_volume_ref (gpointer instance);
void test_volume_unref (gpointer instance);
GParamSpec* param_spec_test_volume (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_volume (GValue* value, gpointer v_object);
void value_take_test_volume (GValue* value, gpointer v_object);
gpointer value_get_test_volume (const GValue* value);
GType test_volume_get_type (void) G_GNUC_CONST;
enum  {
	TEST_VOLUME_DUMMY_PROPERTY
};
static gint test_volume_main (char** args, int args_length1);
static void _g_list_free_g_object_unref (GList* self);
TestVolume* test_volume_new (void);
TestVolume* test_volume_construct (GType object_type);
static void test_volume_finalize (TestVolume* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static char* bool_to_string (gboolean self) {
	char* result = NULL;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gint test_volume_main (char** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		DesktopAgnosticVFSVolumeMonitor* vm;
		desktop_agnostic_vfs_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		vm = _g_object_ref0 (desktop_agnostic_vfs_volume_monitor_get_default (&_inner_error_));
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		{
			GList* vol_collection;
			GList* vol_it;
			vol_collection = desktop_agnostic_vfs_volume_monitor_get_volumes (vm);
			for (vol_it = vol_collection; vol_it != NULL; vol_it = vol_it->next) {
				DesktopAgnosticVFSVolume* vol;
				vol = (DesktopAgnosticVFSVolume*) vol_it->data;
				{
					char* _tmp0_;
					char* _tmp1_;
					g_message ("test-vfs-volume.vala:36: Volume[%s] (Mounted=%s): %s", desktop_agnostic_vfs_volume_get_name (vol), _tmp0_ = bool_to_string (desktop_agnostic_vfs_volume_is_mounted (vol)), _tmp1_ = desktop_agnostic_vfs_file_get_uri (desktop_agnostic_vfs_volume_get_uri (vol)));
					_g_free0 (_tmp1_);
					_g_free0 (_tmp0_);
				}
			}
			__g_list_free_g_object_unref0 (vol_collection);
		}
		desktop_agnostic_vfs_shutdown (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (vm);
			goto __catch0_g_error;
		}
		_g_object_unref0 (vm);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-vfs-volume.vala:43: Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return test_volume_main (argv, argc);
}


TestVolume* test_volume_construct (GType object_type) {
	TestVolume* self = (TestVolume*) g_type_create_instance (object_type);
	return self;
}


TestVolume* test_volume_new (void) {
	return test_volume_construct (TYPE_TEST_VOLUME);
}


static void value_test_volume_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_volume_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_volume_unref (value->data[0].v_pointer);
	}
}


static void value_test_volume_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_volume_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_volume_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_volume_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestVolume* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_volume_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_volume_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestVolume** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_volume_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_volume (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestVolume* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_VOLUME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_volume (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_VOLUME), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_volume (GValue* value, gpointer v_object) {
	TestVolume* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_VOLUME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_VOLUME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_volume_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_volume_unref (old);
	}
}


void value_take_test_volume (GValue* value, gpointer v_object) {
	TestVolume* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_VOLUME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_VOLUME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_volume_unref (old);
	}
}


static void test_volume_class_init (TestVolumeClass * klass) {
	test_volume_parent_class = g_type_class_peek_parent (klass);
	TEST_VOLUME_CLASS (klass)->finalize = test_volume_finalize;
}


static void test_volume_instance_init (TestVolume * self) {
	self->ref_count = 1;
}


static void test_volume_finalize (TestVolume* obj) {
	TestVolume * self;
	self = TEST_VOLUME (obj);
}


GType test_volume_get_type (void) {
	static volatile gsize test_volume_type_id__volatile = 0;
	if (g_once_init_enter (&test_volume_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_volume_init, value_test_volume_free_value, value_test_volume_copy_value, value_test_volume_peek_pointer, "p", value_test_volume_collect_value, "p", value_test_volume_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestVolumeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_volume_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestVolume), 0, (GInstanceInitFunc) test_volume_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_volume_type_id;
		test_volume_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestVolume", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_volume_type_id__volatile, test_volume_type_id);
	}
	return test_volume_type_id__volatile;
}


gpointer test_volume_ref (gpointer instance) {
	TestVolume* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_volume_unref (gpointer instance) {
	TestVolume* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_VOLUME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




