{- This module was generated from data in the Kate syntax
   highlighting file xml.xml, version 2.03, by Wilbert Berendsen (wilbert@kde.nl) -}

module Text.Highlighting.Kate.Syntax.Xml
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "XML"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.docbook;*.xml;*.rc;*.daml;*.rdf;*.rss;*.xspf;*.xsd;*.svg;*.ui;*.kcfg;*.qrc;*.wsdl"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("XML","Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("XML","Start") -> return ()
      ("XML","FindXML") -> return ()
      ("XML","FindEntityRefs") -> return ()
      ("XML","FindPEntityRefs") -> return ()
      ("XML","Comment") -> return ()
      ("XML","CDATA") -> return ()
      ("XML","PI") -> return ()
      ("XML","Doctype") -> return ()
      ("XML","Doctype Internal Subset") -> return ()
      ("XML","Doctype Markupdecl") -> return ()
      ("XML","Doctype Markupdecl DQ") -> return ()
      ("XML","Doctype Markupdecl SQ") -> return ()
      ("XML","Element") -> return ()
      ("XML","El Content") -> return ()
      ("XML","El End") -> return ()
      ("XML","Attribute") -> return ()
      ("XML","Value") -> return ()
      ("XML","Value DQ") -> return ()
      ("XML","Value SQ") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'3c'21DOCTYPE'5cs'2b = compileRegex "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a = compileRegex "<\\?[\\w:_-]*"
regex_'3c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "<(?![0-9])[\\w_:][\\w.:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex "&(#[0-9]+|#[xX][0-9A-Fa-f]+|(?![0-9])[\\w_:][\\w.:_-]*);"
regex_'25'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex "%(?![0-9])[\\w_:][\\w.:_-]*;"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex "-(-(?!->))+"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5cs'2b'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "\\s+(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5cS = compileRegex "\\S"
regex_'3c'2f'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "</(?![0-9])[\\w_:][\\w.:_-]*"

parseRules ("XML","Start") =
  (((parseRules ("XML","FindXML")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","FindXML") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("XML","Comment"))
   <|>
   ((pString False "<![CDATA[" >>= withAttribute BaseNTok) >>~ pushContext ("XML","CDATA"))
   <|>
   ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute DataTypeTok) >>~ pushContext ("XML","Doctype"))
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XML","PI"))
   <|>
   ((pRegExpr regex_'3c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XML","Element"))
   <|>
   ((parseRules ("XML","FindEntityRefs")))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","FindXML")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","FindEntityRefs") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&<" >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","FindEntityRefs")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","FindPEntityRefs") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'25'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&%" >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","FindPEntityRefs")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute ErrorTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("XML","CDATA") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pString False "]]>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pString False "]]&gt;" >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","CDATA")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","PI") =
  (((pDetect2Chars False '?' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","PI")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Doctype") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext ("XML","Doctype Internal Subset"))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Doctype")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Doctype Internal Subset") =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute DataTypeTok) >>~ pushContext ("XML","Doctype Markupdecl"))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("XML","Comment"))
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XML","PI"))
   <|>
   ((parseRules ("XML","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Doctype Internal Subset")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Doctype Markupdecl") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("XML","Doctype Markupdecl DQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("XML","Doctype Markupdecl SQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Doctype Markupdecl")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Doctype Markupdecl DQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("XML","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Doctype Markupdecl DQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XML","Doctype Markupdecl SQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("XML","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Doctype Markupdecl SQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XML","Element") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ pushContext ("XML","El Content"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("XML","Attribute"))
   <|>
   ((pRegExpr regex_'5cs'2b'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("XML","Attribute"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Element")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","El Content") =
  (((pRegExpr regex_'3c'2f'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("XML","El End"))
   <|>
   ((parseRules ("XML","FindXML")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","El Content")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","El End") =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","El End")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Attribute") =
  (((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("XML","Value"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Attribute")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Value") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("XML","Value DQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("XML","Value SQ"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Value")) >> pDefault >>= withAttribute NormalTok))

parseRules ("XML","Value DQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("XML","FindEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Value DQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("XML","Value SQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules ("XML","FindEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("XML","Value SQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("XML","Start") <|> fail ("Unknown context" ++ show x)
