/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import org.w3c.dom.Entity;
import org.w3c.dom.Node;

public class EntityImpl extends NodeImpl implements Entity {

    private String inputEncoding;
    private String notationName;
    private String publicId;
    private String systemId;
    private String xmlEncoding;
    private String xmlVersion;

    public EntityImpl(String name, String systemId) {

        this.systemId = systemId;
        setNodeType(Node.ENTITY_NODE);
        setNodeName(name);
    }
    
    public String getInputEncoding() {
        return inputEncoding;
    }

    public String getNotationName() {
        return notationName;
    }

    public String getPublicId() {
        return publicId;
    }

    public String getSystemId() {
        return systemId;
    }

    public String getXmlEncoding() {
        return xmlEncoding;
    }

    public String getXmlVersion() {
        return xmlVersion;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setNotationName(String notationName) {
        this.notationName = notationName;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

}
