/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class Graph
extends ApplicationFrame {
    public Graph(String string) throws IOException {
        super(string);
        XYDataset xYDataset = this.createDataset("color.dat");
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public Graph(String string, String string2) throws IOException {
        super(string);
        XYDataset xYDataset = this.createDataset(string2);
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
        this.pack();
        RefineryUtilities.centerFrameOnScreen(this);
        this.setVisible(true);
    }

    public Graph(String string, Double[][] doubleArray) throws IOException {
        super(string);
        XYDataset xYDataset = this.createDataset(doubleArray);
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
        this.pack();
        RefineryUtilities.centerFrameOnScreen(this);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XYDataset createDataset(String string) throws IOException {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"First"));
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Second"));
        byte[] byArray = new byte[(int)new File(string).length()];
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedInputStream.read(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string2 = new String(byArray);
        string2 = string2.replace("\t", " ");
        String[] stringArray = string2.split("\n");
        Double[][] doubleArray = new Double[stringArray.length][2];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(" ");
                doubleArray[i][0] = Double.parseDouble(stringArray2[0]);
                doubleArray[i][1] = Double.parseDouble(stringArray2[1]);
                xYSeries2.add(doubleArray[i][0], (Number)doubleArray[i][1]);
            }
        }
        catch (Exception exception) {
            System.err.println("FILENAME: " + string);
            exception.printStackTrace();
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    public XYDataset createDataset(Double[][] doubleArray) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"First"));
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Second"));
        for (int i = 0; i < doubleArray.length; ++i) {
            xYSeries2.add(doubleArray[i][0], (Number)doubleArray[i][1]);
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Line Chart Demo 6", "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setSeriesLinesVisible(0, false);
        xYLineAndShapeRenderer.setSeriesShapesVisible(1, false);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static void main(String[] stringArray) throws IOException {
        Graph graph = new Graph("Line Chart Demo 6");
        graph.pack();
        RefineryUtilities.centerFrameOnScreen(graph);
        graph.setVisible(true);
    }
}

