#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# King's Bounty: The Legend
# send your bug reports to contact@dotslashplay.it
###

script_version=20230331.3

GAME_ID='kings-bounty-the-legend'
GAME_NAME='Kingʼs Bounty: The Legend'

ARCHIVE_BASE_EN_0='setup_kings_bounty_the_legend_1.7_(15542).exe'
ARCHIVE_BASE_EN_0_MD5='f7a9defe0fd96a7f8d6dff6ed7828242'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1='setup_kings_bounty_the_legend_1.7_(15542)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='04fb818107e4bfe7aeae449778e88dd9'
ARCHIVE_BASE_EN_0_SIZE='6000000'
ARCHIVE_BASE_EN_0_VERSION='1.7-gog15542'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/kings_bounty_the_legend'

ARCHIVE_BASE_FR_0='setup_kings_bounty_the_legend_french_1.7_(15542).exe'
ARCHIVE_BASE_FR_0_MD5='646fdfacadc498826be127fe6703f259'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1='setup_kings_bounty_the_legend_french_1.7_(15542)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='907882679fb7050e172994d36730454a'
ARCHIVE_BASE_FR_0_SIZE='6000000'
ARCHIVE_BASE_FR_0_VERSION='1.7-gog15542'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/kings_bounty_the_legend'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.dll
kb.exe
data/default.ini
data/game.ini
data/fonts.cfg'
CONTENT_GAME_L10N_FILES='
data/app.ini
data/loc_data.kfs
sessions/base/loc_ses.kfs'
CONTENT_GAME_DATA_FILES='
curver.txt
data
sessions'
CONTENT_DOC_L10N_FILES='
readme.rtf
manual.pdf'

USER_PERSISTENT_FILES='
data/*.ini
data/fonts.cfg'

WINE_DIRECT3D_RENDERER='dxvk'

APP_MAIN_EXE='kb.exe'

PACKAGES_LIST='PKG_BIN PKG_L10N PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_BASE_EN='English localization'
PKG_L10N_DESCRIPTION_BASE_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_L10N_ID $PKG_DATA_ID"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
