## TFSA-2018-004: Checkpoint Meta File Out-of-Bounds Read

### CVE Number

CVE-2018-7575

### Issue Description

The block size in meta file might contain a large int64 value which causes
an integer overflow upon addition. Subsequent code using n as index may cause
an out-of-bounds read.

### Impact

A maliciously crafted meta checkpoint could be used to cause the TensorFlow
process to perform an out of bounds read on in process memory.

### Vulnerable Versions

TensorFlow 1.0.0, 1.0.1, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0, 1.5.1, 1.6.0, 1.7.0

### Mitigation

We have patched the vulnerability in GitHub commit
[d107fee1](https://github.com/tensorflow/tensorflow/commit/d107fee1e4a9a4462f01564798d345802acc2aef).
If users are running TensorFlow on untrusted meta checkpoints, such as those
downloaded from the Internet, in production or on untrusted data, they are
encouraged to apply this patch.

Additionally, we have released TensorFlow version 1.7.1 to mitigate this
vulnerability.

### Credits

This issue was discovered by the Blade Team of Tencent.
