## Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# Author: Axel Mahler (Axel.Mahler@cs.tu-berlin.de)
#
# $Header: vdiff.sh[4.0] Tue Jun 29 16:41:57 1993 andy@cs.tu-berlin.de frozen $

perror () {
  echo 1>&2 $*
}

match () {
  echo $1 | egrep "$2" > /dev/null
}

cleanup () {
  rm -f $rmlist
}

trapexit () {
  cleanup
  exit $estat
}

afterburner=false
vcatopts=-q
makepatch=false
base=`pwd`/
estat=0
argc=$#

trap trapexit 1 2 3 15 

if [ $argc -lt 1 ]
then
  perror usage: vdiff [ options ] [ -base '<path>' ] file1 [ file2 ]
  exit 1
fi
while [ $argc -gt 0 ]
do
  i=$1
  shift
  argc=`expr $argc - 1`
  case $i in
    -trace) 
	set -x;;
    -ttrace)
	set -v
	set -x;;
    -base)
	if [ $afterburner = true ]
	then
	  if [ $argc -gt 0 ] 
	  then
	    base=$1/
	    shift
	    argc=`expr $argc - 1`
	  else
	    perror usage: vdiff -base requires an argument.
	    exit 1
	  fi
	fi;;
    -c)
	afterburner=true
	options="$options $i";;
    -cset)
	vcatopts="$vcatopts -xpoff";;
    -P)
	makepatch=true;;
    -version)
	echo This is 'vdiff-4.0 (Tue Aug 23 17:59:17 1994 by andy@cs.tu-berlin.de).'
	exit 0;;
    -*)
	options="$options $i";;
    *)
	if [ -z "$fn1" ]
	then
	  fn1=$i
	  fn1t=/tmp/`basename $fn1`
	elif [ -z "$fn2" ]
	then
	  fn2=$i
	  fn2t=/tmp/`basename $fn2`
	else
	  perror usage: vdiff [ options ] [ -base '<path>' ] file1 [ file2 ]
	  exit 1
	fi;;
  esac
done

# $__xpoff$

if [ -z "$fn2" ]
then
# only one filename argument
  if match $fn1 '..*\[.*\]'
  then
  # first and only filename object in bound version notation
    mt1=`vl -format '$__mtime$' $fn1 2> /dev/null`
    fn2=`echo $fn1 | sed -e 's/\[.*\]//'`
    mt2=`vl -format '$__mtime$' $fn2\[busy\] 2> /dev/null`

    if [ "$mt1" = "$mt2" ]
    then
      exit 0;
    fi

    vcat $vcatopts $fn1 > $fn1t          

    if [ $? -gt 0 ]
    then
      perror ${fn1}: No such file or version.
      rm -f $fn1t
      cleanup
      exit 1
    fi

    rmlist="$rmlist $fn1t"

    if [ "$afterburner" = true ]
    then
      diff $options $fn1t $fn2 | \
	sed -e "s,^\([-*]\{3\} \)/tmp/\([^[]*\)\(.*\),\1$base\2 \3," | grep .
      [ $? -gt 0 ]
      estat=$?
    else
      diff $options $fn1t $fn2
      estat=$?
    fi

  else
  # only filename of busy version given
    fn2=`vl -lastsaved $fn1`
    estat=$?
    mt1=`vl -format '$__mtime' $fn1\[busy\] 2> /dev/null`
    estat=`expr $estat \| $?`
    mt2=`vl -format '$__mtime' $fn2 2> /dev/null`
    estat=`expr $estat \| $?`
  
    if [ "$mt1" = "$mt2" ]
    then
      exit 0;
    fi
  
    if [ "$estat" -gt 0 ]
    then
      perror ${fn1}: No such file or version.
      estat=1
      cleanup
      exit $estat
    else
      fn2t=/tmp/`basename $fn2`
    fi
  
    vcat $vcatopts $fn2 > $fn2t 2> /dev/null
  
    if [ $? -gt 0 ]
    then
      perror ${fn2}: No such file or version.
      rm -f $fn2t
      cleanup
      exit $estat
    fi
  
    rmlist="$rmlist $fn2t"
  
    if [ "$afterburner" = true ]
    then
      diff $options $fn2t $fn1 | \
	  sed -e "s,^\([-*]\{3\} \)/tmp/\([^[]*\)\(.*\),\1$base\2 \3," | grep .
      [ $? -gt 0 ]
      estat=`expr $estat \| $?`
    else
      diff $options $fn2t $fn1
      estat=`expr $estat \| $?`
    fi
  
  fi

else                             
# two filename-objects specified

  if match $fn1 '..*\[.*\]'
  then
  # first fn-object in bound version notation
    mt1=`vl -format '$__mtime$' $fn1 2> /dev/null`
    rmlist="$rmlist $fn1t"
    vcat $vcatopts $fn1 > $fn1t 2> /dev/null

    if [ $? -gt 0 ]
    then
      perror ${fn1}: No such file or version.
      if [ "$makepatch" != true ]
      then
        rm -f $fn1t
        cleanup
        exit 1
      fi
    fi

    fn1=$fn1t
  else
    mt1=`vl -format '$__mtime$' $fn1\[busy\] 2> /dev/null`
  fi

  if match $fn2 '..*\[.*\]'
  then
  # second fn-object in bound version notation
    mt2=`vl -format '$__mtime$' $fn2 2> /dev/null`
    rmlist="$rmlist $fn2t"
    vcat $vcatopts $fn2 > $fn2t 2> /dev/null

    if [ $? -gt 0 ]
    then
      perror ${fn2}: No such file or version.
      if [ "$makepatch" != true ]
      then
        rm -f $fn2t
        cleanup
        exit 1
      fi
    fi

    fn2=$fn2t
  else
    mt2=`vl -format '$__mtime' $fn2\[busy\] 2> /dev/null`
  fi

  if [ "$mt1" = "$mt2" ]
  then
    estat=0
  else
    if [ "$afterburner" = true ]
    then
      diff $options $fn1 $fn2 | \
	sed -e "s,^\([-*]\{3\} \)/tmp/\([^[]*\)\(.*\),\1$base\2 \3," | grep .
      [ $? -gt 0 ]
      estat=`expr $estat \| $?`
    else
      diff $options $fn1 $fn2
      estat=`expr $estat \| $?`
    fi
  fi
fi

rm -f $rmlist
exit $estat
