.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXChangeDesktopAttributes __libmansuffix__ __vendorversion__
.SH NAME
DMXChangeDesktopAttributes \- change global bounding box
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "int DMXChangeDesktopAttributes(Display " *dpy ,
.BI "                               unsigned int " mask ,
.BI "                               DMXDesktopAttributes " *attr );
.fi
.SH DESCRIPTION
.B DMXChangeDesktopAttributes()
resizes the bounding box of the whole screen when using the Xinerama
extension.  Otherwise, it has no effect on the screen layout.
An attribute mask is placed in
.I mask
and the attributes to change are placed in
.IR attr .
.PP
The values that are used to compute
.I mask
are as follows:
.sp
.nf
DMXDesktopWidth
DMXDesktopHeight
DMXDesktopShiftX
DMXDesktopShiftY
.fi
.PP
The
.B DMXDesktopAttributes
structure is:
.sp
.nf
typedef struct {
    unsigned int width;
    unsigned int height;
    int          shiftX;
    int          shiftY;
} DMXDesktopAttributes;
.fi
.PP
.I width " and " height
specify the new width and height for the bounding box.
.I shiftX " and " shiftY
specify where the Xinerama origin will be placed with respect to the
origin of the new bounding box.  This allows the left and upper edges of
the bounding box to be changed without changing the visual position of
the windows on the desktop.  If
.I width " or " height
is not specified, the current values will be used.  If
.I shiftX " or " shiftY
is not specified, 0 will be used.
.PP
All coordinates are in the global DMX coordinate system.  If Xinerama is
not active, an error will be generated.
.SH "RETURN VALUE"
.B DMXChangeDesktopAttributes()
will return 0 on success,
.B DmxBadXinerama
if Xinerama is not active,
.B DmxBadValue
if the size of the bounding box is too large, and
.B DmxBadReply
if there was a protocol error.
.PP
.B DMXChangeDesktopAttributes()
can generate
.B BadLength
(if the request is malformed, which should never happen when using this
library interface), and
.B BadValue
(if any values are out of range).
.SH "SEE ALSO"
.BR DMXGetDesktopAttributes "(__libmansuffix__), " DMX "(__libmansuffix__), " Xdmx (1)
