#include "FactorHiGHS.h"

#include "Analyse.h"
#include "DataCollector.h"
#include "Factorise.h"
#include "ipm/hipo/auxiliary/Log.h"

namespace hipo {

FHsolver::FHsolver(const Log* log, Int block_size)
    : log_{log}, nb_{block_size > 0 ? block_size : default_nb_} {
#ifdef HIPO_COLLECT_EXPENSIVE_DATA
  if (log_)
    log_->printw(
        "Running in debug mode: COLLECTING EXPENSIVE FACTORISATION DATA\n");
#endif
#if HIPO_TIMING_LEVEL > 0
  if (log_)
    log_->printw("Running in debug mode: COLLECTING EXPENSIVE TIMING DATA\n");
#endif
}

FHsolver::~FHsolver() {
  if (log_) {
    data_.printTimes(*log_);
    data_.printIter(*log_);
  }
}

void FHsolver::newIter() { data_.append(); }

void FHsolver::setRegularisation(double reg_p, double reg_d) {
  regul_.primal = reg_p;
  regul_.dual = reg_d;
}

Int FHsolver::analyse(Symbolic& S, const std::vector<Int>& rows,
                      const std::vector<Int>& ptr,
                      const std::vector<Int>& signs) {
  Analyse an_obj(rows, ptr, signs, nb_, log_, data_);
  return an_obj.run(S);
}

Int FHsolver::factorise(const Symbolic& S, const std::vector<Int>& rows,
                        const std::vector<Int>& ptr,
                        const std::vector<double>& vals) {
  Factorise fact_obj(S, rows, ptr, vals, regul_, log_, data_, sn_columns_);
  return fact_obj.run(N_);
}

Int FHsolver::solve(std::vector<double>& x, Int* solve_count, double* omega) {
  return N_.solve(x, solve_count, omega);
}

}  // namespace hipo