/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLWriter;
import org.apache.woden.internal.WSDLContext;
import org.apache.woden.internal.WriterFeatures;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;

public abstract class BaseWSDLWriter
implements WSDLWriter {
    private String fFactoryImplName = null;
    protected WSDLContext fWsdlContext;
    protected final WriterFeatures features;

    public BaseWSDLWriter(WSDLContext wsdlContext) {
        this.fWsdlContext = wsdlContext;
        this.fFactoryImplName = this.fWsdlContext.wsdlFactory.getClass().getName();
        this.features = new WriterFeatures();
    }

    public ErrorReporter getErrorReporter() {
        return this.fWsdlContext.errorReporter;
    }

    protected WSDLFactory getFactory() throws WSDLException {
        return this.fWsdlContext.wsdlFactory;
    }

    public void setFactoryImplName(String factoryImplName) {
        this.fFactoryImplName = factoryImplName;
    }

    public String getFactoryImplName() {
        return this.fFactoryImplName;
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        if (extReg == null) {
            String msg = this.fWsdlContext.errorReporter.getFormattedMessage("WSDL014", new Object[0]);
            throw new NullPointerException(msg);
        }
        this.fWsdlContext = new WSDLContext(this.fWsdlContext.wsdlFactory, this.fWsdlContext.errorReporter, extReg, this.fWsdlContext.uriResolver);
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.fWsdlContext.extensionRegistry;
    }

    public void setFeature(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL005", null));
        }
        try {
            this.features.setValue(name, value);
        }
        catch (IllegalArgumentException e) {
            Object[] args = new Object[]{name};
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL006", args));
        }
    }

    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL005", null));
        }
        try {
            return this.features.getValue(name);
        }
        catch (IllegalArgumentException e) {
            Object[] args = new Object[]{name};
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL006", args));
        }
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL007", null));
        }
        if (!name.equals("xyz")) {
            Object[] args = new Object[]{name};
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL008", args));
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL007", null));
        }
        if (name.equals("xyz")) {
            return null;
        }
        Object[] args = new Object[]{name};
        throw new IllegalArgumentException(this.fWsdlContext.errorReporter.getFormattedMessage("WSDL008", args));
    }
}

