/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.BaseServer;
import org.apache.vinci.transport.BaseServerRunnable;
import org.apache.vinci.transport.ErrorFrame;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.VinciServableAdapter;
import org.apache.vinci.transport.vns.service.BackupThread;
import org.apache.vinci.transport.vns.service.CachedItem;
import org.apache.vinci.transport.vns.service.ProxyCachedItem;
import org.apache.vinci.transport.vns.service.Service;
import org.apache.vinci.transport.vns.service.ServiceAlias;
import org.apache.vinci.transport.vns.service.ServiceRegistry;
import org.apache.vinci.transport.vns.service.WorkspaceConfig;
import org.apache.vinci.transport.vns.service.exitThread;

public class VNS
extends VinciServableAdapter {
    private HashMap cachedResults = new HashMap();
    public static final String dirCmdAddService = "addservice";
    public static final String dirCmdAddAlias = "addalias";
    public static final String dirCmdDelService = "delservice";
    public static final String dirCmdDelAlias = "delalias";
    public static final String dirCmdUpdateService = "updateservice";
    public static final String dirCmdGetList = "getlist";
    public static final String dirCmdGetNames = "getnames";
    public static final String dirCmdGetHits = "gethits";
    public String ENV_PROXY = "vinci.environment.proxy";
    private static String configFile;
    private static String backupFile;
    private static String workspacesFile;
    private static String counterFile;
    private static String logFile;
    private static String configDir;
    private static int backupInterval;
    private static int srvPort;
    private static boolean logFlag;
    private static String bindAddress;
    private static int backlog;
    private static int maxThreads;
    int port;
    String myLogFile = null;
    Thread backupThread;
    BackupThread backupThreadRunnable;
    Hashtable hits;
    int totalhits = 0;
    ServiceRegistry SR = new ServiceRegistry();
    WorkspaceConfig WS = new WorkspaceConfig(this);
    Writer log;
    String starttime;
    static File quitFile;

    private static void setConfigDir(String path) {
        if (path.charAt(path.length() - 1) == File.separatorChar) {
            path = path.substring(0, path.length() - 1);
        }
        configDir = path;
        configFile = path + File.separatorChar + "vns.services";
        backupFile = path + File.separatorChar + "vns.services.bak";
        workspacesFile = path + File.separatorChar + "vns.workspaces";
        counterFile = path + File.separatorChar + "vns.counter";
        quitFile = new File(configDir + File.separatorChar + "quit");
        quitFile.delete();
    }

    public static void main(String[] args) throws IOException {
        Debug.setThreadNameOutput(true);
        System.setProperty("sun.net.inetaddr.ttl", "30");
        Security.setProperty("networkaddress.cache.ttl", "30");
        VNS.setConfigDir(".");
        for (int i = 0; i < args.length; ++i) {
            String s = args[i].trim();
            if (s.equals("-h") || s.equals("--help")) {
                VNS.printUsage();
                return;
            }
            if (s.equals("-l") || s.equals("--logfile")) {
                logFile = args[++i];
                logFlag = true;
                Debug.p("Log file set to: " + logFile);
                continue;
            }
            if (s.equals("-p") || s.equals("--port")) {
                srvPort = Integer.parseInt(args[++i]);
                Debug.p("Service port set to: " + srvPort);
                continue;
            }
            if (s.equals("-b") || s.equals("--bind")) {
                bindAddress = args[++i];
                Debug.p("Bind address set to: " + bindAddress);
                continue;
            }
            if (s.equals("-g") || s.equals("--backlog")) {
                backlog = Integer.parseInt(args[++i]);
                Debug.p("Backlog set to: " + backlog);
                continue;
            }
            if (s.equals("-m") || s.equals("--maxthreads")) {
                maxThreads = Integer.parseInt(args[++i]);
                Debug.p("Max threads set to: " + maxThreads);
                continue;
            }
            if (s.equals("-i") || s.equals("--interval")) {
                backupInterval = Integer.parseInt(args[++i]);
                Debug.p("Backup interval set to: " + backupInterval);
                continue;
            }
            if (s.equals("-a") || s.equals("--logging")) {
                Debug.p("Access logging enabled.");
                logFlag = true;
                continue;
            }
            if (s.equals("-c") || s.equals("--config")) {
                String dir = args[++i];
                Debug.p("Config directory set to: " + dir);
                VNS.setConfigDir(dir);
                continue;
            }
            System.out.println("Unrecognized option : " + args[i]);
            VNS.printUsage();
            return;
        }
        VNS.startServing();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.vinci.transport.vns.service.VNS [options]");
        System.out.println("  -p N  --port N");
        System.out.println("    Serve on port number N [default=" + srvPort + "]");
        System.out.println("  -b ip_address  --bind ip_address");
        System.out.println("    Force socket server to bind only to ip_address [default is bind to all]");
        System.out.println("  -c dirname --config dirname");
        System.out.println("    Look for & write config files in this directory [default=.]");
        System.out.println("  -i N  --interval N");
        System.out.println("    Backup every N seconds [default=" + backupInterval + "]");
        System.out.println("  -l fname  --logfile fname");
        System.out.println("    Access log pathname [default=<configdir>/vns.log]");
        System.out.println("  -a  --logging");
        System.out.println("    Enable access logging (implied by -l/--logfile option)");
        System.out.println("  -g N  --backlog N");
        System.out.println("    Set the ServerSocket backlog [default=" + backlog + "]");
        System.out.println("  -m N  --maxthreads N");
        System.out.println("    Set the maximum size of the VNS thread pool [default=" + maxThreads + "].");
        System.out.println("  -h  --help");
        System.out.println("    This help message");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServing() throws IOException {
        VNS vns;
        if (logFlag) {
            if (logFile == null) {
                logFile = configDir + File.separatorChar + "vns.log";
            }
            vns = new VNS(srvPort, logFile);
        } else {
            vns = new VNS(srvPort);
        }
        if (!vns.loadConfig(configFile)) {
            System.err.println("failed to load config file: " + configFile);
            System.err.println("Check its path and validity. If necessary, restore from backup.");
            System.exit(1);
        }
        vns.loadWorkspaces(workspacesFile);
        Debug.p("VNS Workspace : " + vns.WS.workspace);
        vns.loadCounters(counterFile);
        Debug.p("Starting backup thread, using files " + backupFile + " and " + configFile);
        vns.backupThreadRunnable = new BackupThread(vns, backupFile, configFile, backupInterval, counterFile);
        vns.backupThread = new Thread(vns.backupThreadRunnable);
        vns.backupThread.start();
        Debug.p("Serving on port : " + vns.port);
        BaseServer server = null;
        server = bindAddress != null ? new BaseServer(vns){

            @Override
            protected ServerSocket createServerSocket(int port) throws IOException {
                return new ServerSocket(port, backlog, InetAddress.getByName(bindAddress));
            }
        } : new BaseServer(vns){

            @Override
            protected ServerSocket createServerSocket(int port) throws IOException {
                return new ServerSocket(port, backlog);
            }
        };
        server.setSocketTimeout(5000);
        exitThread exitT = new exitThread(server);
        exitT.start();
        try {
            server.setThreadPoolSize(5, maxThreads);
            server.serve(vns.port);
        }
        catch (Throwable e) {
            Debug.reportException(e);
        }
        finally {
            Debug.p("Exiting.");
            System.exit(0);
        }
    }

    public VNS() {
        this.hits = new Hashtable();
        this.starttime = new Date().toString();
    }

    public VNS(int port) {
        this();
        this.port = port;
    }

    public VNS(int port, String logFile) throws IOException {
        this();
        this.port = port;
        this.myLogFile = new String(logFile);
        this.log = new BufferedWriter(new FileWriter(this.myLogFile, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfig(String cFile) {
        File f = new File(cFile);
        if (!f.exists()) {
            Debug.p("WARNING: Config file doesn't exist, creating a new empty config file!");
            try {
                FileWriter writer = new FileWriter(f);
                writer.write("<CONFIGURATION></CONFIGURATION>");
                writer.close();
            }
            catch (IOException e) {
                Debug.reportException(e);
                return false;
            }
        }
        Debug.p("Loading config file : " + cFile);
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            try {
                this.SR.load(cFile);
                return true;
            }
            catch (Exception e) {
                Debug.reportException(e);
            }
        }
        return false;
    }

    public void loadWorkspaces(String wFile) {
        Debug.p("Loading workspaces file : " + wFile);
        try (FileReader F = new FileReader(wFile);){
            this.WS.load(F);
        }
        catch (Exception e) {
            Debug.reportException(e);
            Debug.p("WARNING: failed to load workspace.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadCounters(String cFile) {
        FileReader F;
        Debug.p("Loading counter file : " + cFile);
        int line = 1;
        try {
            F = new FileReader(cFile);
        }
        catch (FileNotFoundException e) {
            Debug.p("Could not load the counter file : " + cFile);
            return;
        }
        BufferedReader br = new BufferedReader(F);
        try {
            String s = br.readLine();
            if (s == null || s.trim().equals("")) {
                Debug.p("Invalid counter file format at line 1: " + cFile);
                br.close();
                F.close();
                return;
            }
            StringTokenizer str = new StringTokenizer(s);
            if (str.countTokens() <= 1) {
                Debug.p("Invalid counter file format at line 1: " + cFile);
                br.close();
                F.close();
                return;
            }
            if (!str.nextToken().equals("TOTAL")) {
                throw new Exception("First line invalid - does not start with TOTAL");
            }
            this.totalhits = Integer.parseInt(str.nextToken());
            this.hits = new Hashtable();
            ++line;
            while ((s = br.readLine()) != null) {
                str = new StringTokenizer(s);
                this.hits.put(str.nextToken(), new Integer(str.nextToken()));
                ++line;
            }
            br.close();
            F.close();
            return;
        }
        catch (IOException e2) {
            Debug.p("IO Problem while reading from counter file : " + cFile);
            Debug.p("Exception was : " + e2);
            return;
        }
        catch (NumberFormatException e3) {
            Debug.p("Invalid number specified in counter file " + cFile + " at line " + line);
            return;
        }
        catch (Exception e4) {
            Debug.p("Problem while parsing counter file : " + cFile);
            Debug.p("Exception generated : " + e4);
            return;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e2) {}
            try {
                F.close();
            }
            catch (IOException e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(String cFile) {
        Debug.p("Saving to config file : " + cFile);
        long startTime = System.currentTimeMillis();
        Object object = this.SR;
        synchronized (object) {
            BufferedWriter F = null;
            try {
                F = new BufferedWriter(new FileWriter(cFile + ".rename"));
                try {
                    this.SR.save(F);
                }
                finally {
                    ((Writer)F).close();
                }
                File real_file = new File(cFile);
                real_file.delete();
                if (!new File(cFile + ".rename").renameTo(real_file)) {
                    throw new IOException("FAILED to rename services config file!!!");
                }
            }
            catch (IOException e) {
                Debug.reportException(e);
                Debug.p("Could not save config file : " + cFile);
            }
        }
        startTime = System.currentTimeMillis() - startTime;
        Debug.p("Config save required " + startTime + " millis.");
        if (this.log != null) {
            object = this.log;
            synchronized (object) {
                try {
                    this.log.flush();
                }
                catch (IOException e) {
                    Debug.reportException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCounters(String cFile) {
        FileWriter F;
        Debug.p("Saving counter file : " + cFile);
        try {
            F = new FileWriter(cFile);
        }
        catch (IOException e) {
            Debug.p("Could not save the counter file : " + cFile);
            Debug.p("Exception generated : " + e);
            return;
        }
        try {
            F.write("TOTAL " + this.totalhits + "\n");
            if (this.hits == null) {
                F.close();
                return;
            }
            Enumeration keys = this.hits.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Integer value = (Integer)this.hits.get(key);
                F.write(key.trim() + " " + value + "\n");
            }
        }
        catch (IOException e2) {
            Debug.reportException(e2);
            Debug.p("IO Problem while writing to counter file : " + cFile);
        }
        finally {
            try {
                if (F != null) {
                    F.close();
                }
            }
            catch (IOException e3) {
                Debug.reportException(e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWorkspaces(String wFile) {
        Debug.p("Loading workspaces file : " + wFile);
        Writer F = null;
        try {
            F = new BufferedWriter(new FileWriter(wFile));
            this.WS.save(F);
            F.close();
        }
        catch (IOException e) {
            Debug.p("Could not save workspaces file : " + wFile);
            Debug.p("Exception generated : " + e);
        }
        catch (RuntimeException e2) {
            Debug.p("Problem while saving workspace file : " + wFile);
            Debug.p("Exception generated: " + e2);
        }
        finally {
            try {
                if (F != null) {
                    F.close();
                }
            }
            catch (IOException e) {
                Debug.reportException(e);
            }
        }
    }

    @Override
    public Transportable eval(Transportable inp) throws ServiceException {
        VinciFrame in = (VinciFrame)inp;
        VinciFrame out = null;
        Debug.p("Request from " + in.fgetString("vinci:REMOTEIP"));
        String command = in.fgetString("vinci:COMMAND");
        if (command == null) {
            out = new VinciFrame();
            out.fadd("vinci:ERROR", "Malformed request");
            return out;
        }
        try {
            if ("resolve".equals(command)) {
                out = this.resolve(in);
            } else if ("serveon".equals(command)) {
                out = this.serveon(in);
            } else if (command.equals(dirCmdAddService)) {
                out = this.addService(in);
            } else if (command.equals(dirCmdAddAlias)) {
                out = this.addAlias(in);
            } else if (command.equals(dirCmdUpdateService)) {
                out = this.updateService(in);
            } else if (command.equals(dirCmdDelService)) {
                out = this.delService(in);
            } else if (command.equals(dirCmdDelAlias)) {
                out = this.delAlias(in);
            } else if (command.equals(dirCmdGetList)) {
                out = this.getList(in);
            } else if (command.equals(dirCmdGetNames)) {
                out = this.getNames(in);
            } else if (command.equals(dirCmdGetHits)) {
                out = this.getHits(in);
            } else {
                out = new VinciFrame();
                out.fadd("vinci:ERROR", "Unrecognized command");
            }
        }
        catch (Exception e) {
            out = new VinciFrame();
            out.fadd("vinci:ERROR", "Critical error :\n" + e + "\nThe server MAY not respond to further requests.\nPlease notify the administrator\n");
            e.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame resolveLocal(VinciFrame in) {
        int i;
        Service[] servicesList;
        Debug.p("Local resolve");
        VinciFrame out = new VinciFrame();
        String name = in.fgetString("SERVICE");
        if (VNS.strip(name) == null) {
            return new ErrorFrame("No service name specified");
        }
        String host = VNS.strip(in.fgetString("HOST"));
        String realhost = VNS.strip(in.fgetString("IP"));
        if (VNS.strip(realhost) == null && VNS.strip(host) != null) {
            try {
                realhost = InetAddress.getByName(host).getHostAddress();
            }
            catch (Exception e) {
                return new ErrorFrame("Could not resolve IP address for service " + name);
            }
        }
        String instance = in.fgetString("INSTANCE");
        int inst = -1;
        try {
            inst = Integer.parseInt(instance);
        }
        catch (Exception e) {
            inst = -1;
        }
        String level = in.fgetString("LEVEL");
        if (VNS.strip(level) == null || level.trim().toLowerCase().equals("none")) {
            level = "-1";
        } else if (level.toLowerCase().equals("all")) {
            Debug.p("Specific level must be given (not all)");
            out.fadd("vinci:ERROR", "Specific level must be given (not all)");
            return out;
        }
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            level = "" + this.SR.getLevel(name, level);
        }
        CachedItem citem = (CachedItem)this.checkCache(name + "[" + level + "]");
        if (citem == null) {
            ServiceRegistry serviceRegistry2 = this.SR;
            synchronized (serviceRegistry2) {
                servicesList = this.SR.getServices(name, level, true);
            }
            if (servicesList != null && servicesList.length > 0) {
                this.cache(name + "[" + servicesList[0].level + "]", new CachedItem(servicesList));
                if (!servicesList[0].level.equals(level)) {
                    this.cache(name + "[" + level + "]", new ProxyCachedItem(name + "[" + servicesList[0].level + "]"));
                }
            }
        } else {
            servicesList = citem.servicesList;
        }
        if (servicesList == null) {
            Debug.p("Service " + name + " not found");
            out.fadd("vinci:ERROR", "Service " + name + " not found");
            return out;
        }
        Debug.p("Number of services found with name = " + name + ", and level = " + level + " : " + servicesList.length);
        if (servicesList.length == 0) {
            System.err.println("NO SERVICES FOUND WITH REALHOST = " + realhost + " name = " + name);
        }
        ArrayList<Service> v = new ArrayList<Service>();
        for (i = 0; i < servicesList.length; ++i) {
            if (realhost != null && !servicesList[i].realhost.equals(realhost) || inst > -1 && inst != servicesList[i].instance) continue;
            v.add(servicesList[i]);
        }
        servicesList = new Service[v.size()];
        for (i = 0; i < v.size(); ++i) {
            servicesList[i] = (Service)v.get(i);
        }
        if (servicesList == null || servicesList.length == 0) {
            Debug.p("Service " + name + " not found");
            out.fadd("vinci:ERROR", "Service " + name + " not found");
            return out;
        }
        for (int j = 0; j < servicesList.length; ++j) {
            VinciFrame temp = new VinciFrame();
            temp.fadd("HOST", (String)servicesList[j].getAttr("host"));
            temp.fadd("PORT", "" + servicesList[j].port);
            temp.fadd("INSTANCE", "" + servicesList[j].instance);
            if (servicesList[j].meta) {
                Object o = servicesList[j].dict.get("META");
                if (o instanceof String) {
                    temp.fadd("META", (String)o);
                }
                if (o instanceof Frame) {
                    temp.fadd("META", (Frame)o);
                }
            }
            out.fadd("SERVER", temp);
        }
        out.fadd("LEVEL", servicesList[0].level);
        return out;
    }

    VinciFrame resolveProxy(VinciFrame in, String workspace) {
        Debug.p("Proxy resolve");
        if (workspace == null) {
            workspace = in.fgetString("WORKSPACE");
        }
        if (workspace == null || workspace.equals(this.WS.workspace)) {
            return this.resolveLocal(in);
        }
        Service[] services = this.SR.getServices(this.ENV_PROXY);
        VinciFrame out = new VinciFrame();
        if (services == null || services.length == 0) {
            out.fadd("vinci:ERROR", "Cannot locate proxy service");
            return out;
        }
        for (int i = 0; i < services.length; ++i) {
            Service S = services[i];
            if (S.realhost == null) continue;
            try {
                if (S.port == srvPort && InetAddress.getLocalHost().getHostAddress().equals(S.realhost)) {
                    out = this.resolveLocal(in);
                } else {
                    Debug.p("Resolving with VNS: " + S.realhost + ":" + S.port);
                    out = BaseClient.rpc(in, S.realhost, S.port);
                }
                System.out.println(out.toXML());
                if (out == null || out instanceof ErrorFrame || VNS.strip(out.fgetString("LEVEL")) == null || out.fgetString("vinci:ERROR") != null) continue;
                return out;
            }
            catch (ServiceException se) {
                System.out.println(se);
                se.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                out.fadd("vinci:ERROR", "Proxy forwarding failed due to " + e);
                return out;
            }
        }
        return new ErrorFrame("Proxy forwarding failed");
    }

    VinciFrame resolveDefaults(VinciFrame in) {
        String name = in.fgetString("SERVICE");
        if (this.WS.workspace == null || this.WS.search.size() == 0) {
            return this.resolveLocal(in);
        }
        for (int i = 0; i < this.WS.search.size(); ++i) {
            VinciFrame out;
            String workspace = (String)this.WS.search.get(i);
            if (workspace.equals(this.WS.workspace)) {
                Debug.p("Resolving on local workspace ...");
                out = this.resolveLocal(in);
            } else {
                Debug.p("Resolving on workspace " + workspace + " ...");
                out = this.resolveProxy(in, workspace);
            }
            if (out.fgetString("vinci:ERROR") != null) continue;
            return out;
        }
        Debug.p("Resolution failed");
        return new ErrorFrame("Could not find service " + name + " in default workspaces");
    }

    VinciFrame resolve(VinciFrame in) {
        this.logRequest("resolve", in.fgetString("vinci:REMOTEIP"), in.fgetString("SERVICE"));
        if (in.fgetString("WORKSPACE") == null) {
            return this.resolveDefaults(in);
        }
        Debug.p("Resolving on workspace " + in.fgetString("WORKSPACE") + " ...");
        return this.resolveProxy(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame serveon(VinciFrame in) {
        Service[] services;
        String level;
        this.logRequest("serveon", in.fgetString("vinci:REMOTEIP"), null);
        Service S = null;
        Service srv = null;
        VinciFrame out = new VinciFrame();
        String name = in.fgetString("SERVICE");
        if (VNS.strip(name) == null) {
            return new ErrorFrame("Invalid service name specified : " + name);
        }
        String host = in.fgetString("HOST");
        if (VNS.strip(host) == null) {
            Debug.p("Getting host from socket peer info");
            host = in.fgetString("vinci:REMOTEHOST");
            if (host == null) {
                host = in.fgetString("vinci:REMOTEIP");
            }
            if (host == null) {
                return new ErrorFrame("Host could not be parsed - specify HOST");
            }
            Debug.p("Peer host is : " + host);
        }
        if (VNS.strip(level = in.fgetString("LEVEL")) == null || level.trim().toLowerCase().equals("none")) {
            level = "0";
        }
        if (level.equals("all")) {
            out.fadd("vinci:ERROR", "Specific level must be given or none at all");
            return out;
        }
        String instance = in.fgetString("INSTANCE");
        try {
            instance = "" + Integer.parseInt(instance);
        }
        catch (Exception e) {
            instance = null;
        }
        if (instance == null) {
            instance = "0";
        }
        Debug.p("Host = " + host);
        String realhost = in.fgetString("IP");
        try {
            if (realhost == null) {
                realhost = InetAddress.getByName(host).getHostAddress();
            }
        }
        catch (Exception e) {
            out.fadd("vinci:ERROR", "Could not resolve IP due to Exception " + e);
            return out;
        }
        Debug.p("search: realhost = " + realhost + " - instance = " + instance);
        ServiceRegistry e = this.SR;
        synchronized (e) {
            level = "" + this.SR.getLevel(name, level);
        }
        Debug.p("Level = " + level);
        this.updateCache(name + "[" + level + "]");
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            services = this.SR.getServices(name, level);
        }
        if (services != null) {
            for (int i = 0; i < services.length; ++i) {
                S = services[i];
                Debug.p("current: realhost = " + S.realhost + " - instance = " + S.instance);
                if (!S.realhost.equals(realhost) || !instance.equals("" + S.instance) || !S.level.equals(level)) continue;
                srv = S;
                break;
            }
        }
        if (srv == null) {
            Debug.p("Creating now");
            Hashtable<String, String> H = new Hashtable<String, String>();
            H.put("NAME", name);
            H.put("HOST", host);
            H.put("LEVEL", level);
            H.put("INSTANCE", instance);
            H.put("IP", realhost);
            srv = new Service(H);
            boolean ok = false;
            ServiceRegistry serviceRegistry2 = this.SR;
            synchronized (serviceRegistry2) {
                Debug.p("Adding service : " + H.get("NAME") + ", lvl=" + H.get("LEVEL") + ",instance=" + H.get("INSTANCE") + ",ip=" + H.get("IP"));
                ok = this.SR.addService(srv);
            }
            if (!ok) {
                out.fadd("vinci:ERROR", "COuld not find or add service " + name);
                return out;
            }
        } else if (srv.minport != srv.maxport) {
            final String s_host = srv.host;
            final int s_port = srv.port;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Debug.p("Trying to shutdown old service ...");
                    VinciFrame shutdown = new VinciFrame();
                    shutdown.fadd("vinci:SHUTDOWN", "Identical service started on this host. Use the INSTANCE tag to run multiple instances of the same service on a single host.");
                    try {
                        VinciFrame f = BaseClient.rpc(shutdown, s_host, s_port, 10000);
                        Debug.p("Shutdown response received: " + f.toXML());
                    }
                    catch (Exception e) {
                        Debug.p("Old service already closed: " + e);
                    }
                }
            }).start();
        }
        srv.updatePort();
        out.fadd("HOST", srv.host);
        out.fadd("PORT", srv.port);
        out.fadd("LEVEL", srv.level);
        out.fadd("INSTANCE", srv.instance);
        out.fadd("IP", srv.realhost);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame addService(VinciFrame in) {
        this.logRequest(dirCmdAddService, in.fgetString("vinci:REMOTEIP"), null);
        VinciFrame service = in.fgetVinciFrame("SERVICE");
        Hashtable<String, Object> H = new Hashtable<String, Object>();
        int total = service.getKeyValuePairCount();
        for (int i = 0; i < total; ++i) {
            KeyValuePair P = service.getKeyValuePair(i);
            if (P.isValueALeaf()) {
                H.put(P.getKey(), P.getValueAsString());
                continue;
            }
            H.put(P.getKey(), P.getValue());
        }
        String level = (String)H.get("LEVEL");
        if (VNS.strip(level) == null) {
            H.put("LEVEL", "0");
        }
        boolean ok = false;
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            Service S = new Service(H);
            ok = this.SR.addService(S);
            this.updateCache(S);
        }
        return this.getFrame(ok, "Add Service request failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame addAlias(VinciFrame in) {
        this.logRequest(dirCmdAddAlias, in.fgetString("vinci:REMOTEIP"), null);
        VinciFrame service = in.fgetVinciFrame("SERVICE");
        boolean ok = true;
        if (service.fgetString("NAME") == null || service.fgetString("TARGET") == null) {
            this.getFrame(false, "Malformed request");
        } else {
            ServiceRegistry serviceRegistry = this.SR;
            synchronized (serviceRegistry) {
                ok = this.SR.addAlias(new ServiceAlias(service.fgetString("NAME"), service.fgetString("TARGET")));
            }
        }
        return this.getFrame(ok, "Add alias request failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame delService(VinciFrame in) {
        this.logRequest(dirCmdDelService, in.fgetString("vinci:REMOTEIP"), null);
        VinciFrame service = in.fgetVinciFrame("SERVICE");
        Hashtable<String, Object> H = new Hashtable<String, Object>();
        int total = service.getKeyValuePairCount();
        KeyValuePair P = null;
        for (int i = 0; i < total; ++i) {
            P = service.getKeyValuePair(i);
            if (P.isValueALeaf()) {
                H.put(P.getKey(), P.getValueAsString());
                continue;
            }
            H.put(P.getKey(), P.getValue());
        }
        String level = (String)H.get("LEVEL");
        if (VNS.strip(level) == null) {
            H.put("LEVEL", "0");
        }
        boolean ok = false;
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            Service S = new Service(H);
            ok = this.SR.delService(S);
            this.updateCache(S);
        }
        return this.getFrame(ok, "Delete Service request failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame delAlias(VinciFrame in) {
        this.logRequest(dirCmdDelAlias, in.fgetString("vinci:REMOTEIP"), null);
        VinciFrame service = in.fgetVinciFrame("SERVICE");
        boolean ok = true;
        if (service.fgetString("NAME") == null || service.fgetString("TARGET") == null) {
            this.getFrame(false, "Malformed request");
        } else {
            ServiceRegistry serviceRegistry = this.SR;
            synchronized (serviceRegistry) {
                ok = this.SR.delAlias(service.fgetString("NAME"));
            }
        }
        return this.getFrame(ok, "Delete alias request failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame updateService(VinciFrame in) {
        this.logRequest(dirCmdUpdateService, in.fgetString("vinci:REMOTEIP"), null);
        VinciFrame service = in.fgetVinciFrame("SERVICE");
        Hashtable<String, Object> H = new Hashtable<String, Object>();
        int total = service.getKeyValuePairCount();
        for (int i = 0; i < total; ++i) {
            KeyValuePair P = service.getKeyValuePair(i);
            if (P.isValueALeaf()) {
                H.put(P.getKey(), P.getValueAsString());
                continue;
            }
            H.put(P.getKey(), P.getValue());
        }
        boolean ok = false;
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            Service S = new Service(H);
            ok = this.SR.updateService(S);
            this.updateCache(S);
        }
        return this.getFrame(ok, "Update Service request failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame getList(VinciFrame in) {
        Object[] servicelist;
        String prefix;
        String level = in.fgetString("LEVEL");
        if (level == null || level.trim().toLowerCase().equals("none")) {
            level = "-1";
        }
        if ((prefix = in.fgetString("PREFIX")) == null) {
            prefix = "";
        }
        this.logRequest(dirCmdGetList, in.fgetString("vinci:REMOTEIP"), prefix);
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            Debug.p("Getting list for level : " + level);
            servicelist = this.SR.listServices(prefix, level);
            if (servicelist == null) {
                servicelist = new Object[]{};
            }
            Debug.p("Matches for getList : " + servicelist.length);
        }
        VinciFrame F = new VinciFrame();
        for (int i = 0; i < servicelist.length; ++i) {
            if (ServiceAlias.isAlias(servicelist)) {
                F.fadd("SERVICE", ((ServiceAlias)servicelist[i]).toFrame());
                continue;
            }
            F.fadd("SERVICE", ((Service)servicelist[i]).toFrame());
        }
        return F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VinciFrame getNames(VinciFrame in) {
        String[] servicelist;
        String prefix;
        String level = in.fgetString("LEVEL");
        if (level == null || level.trim().toLowerCase().equals("none")) {
            level = "-1";
        }
        if ((prefix = in.fgetString("PREFIX")) == null) {
            prefix = "";
        }
        this.logRequest(dirCmdGetNames, in.fgetString("vinci:REMOTEIP"), prefix);
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            Debug.p("Getting names list for level : " + level);
            servicelist = this.SR.listNames(prefix, level);
            if (servicelist == null) {
                servicelist = new String[]{};
            }
            Debug.p("Matches for getNames : " + servicelist.length);
        }
        VinciFrame F = new VinciFrame();
        for (int i = 0; i < servicelist.length; ++i) {
            F.fadd("SERVICE", servicelist[i]);
        }
        return F;
    }

    /*
     * Enabled aggressive block sorting
     */
    VinciFrame getHits(VinciFrame in) {
        String type = in.fgetString("TYPE");
        VinciFrame F = new VinciFrame();
        if (type != null) {
            if (type.equals("all")) {
                Enumeration keys = this.hits.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    VinciFrame temp = new VinciFrame();
                    temp.fadd("TYPE", key);
                    temp.fadd("COUNT", this.hits.get(key).toString());
                    F.fadd("HITS", temp);
                }
                F.fadd("TOTAL", "" + this.totalhits);
            } else {
                if (this.hits.get(type) == null) {
                    F.fadd("vinci:ERROR", "No such type: " + type);
                    return F;
                }
                F.fadd("HITS", this.hits.get(type).toString());
            }
        } else {
            F.fadd("HITS", "" + this.totalhits);
        }
        F.fadd("STARTED", "" + this.starttime);
        return F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(String s, Object o) {
        HashMap hashMap = this.cachedResults;
        synchronized (hashMap) {
            this.cachedResults.put(s, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(String s) {
        HashMap hashMap = this.cachedResults;
        synchronized (hashMap) {
            this.cachedResults.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service updateCache(Service S) {
        String name = (String)S.getAttr("name");
        String level = "";
        ServiceRegistry serviceRegistry = this.SR;
        synchronized (serviceRegistry) {
            level = "" + this.SR.getLevel(name, (String)S.getAttr("level"));
        }
        this.updateCache(name + "[" + level + "]");
        return S;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkCache(String s) {
        HashMap hashMap = this.cachedResults;
        synchronized (hashMap) {
            Object o = null;
            do {
                if ((o = this.cachedResults.get(s)) == null) {
                    return null;
                }
                if (!(o instanceof ProxyCachedItem)) continue;
                s = ((ProxyCachedItem)o).altKey;
            } while (!(o instanceof CachedItem));
            return o;
        }
    }

    VinciFrame getFrame(boolean ok, String err) {
        VinciFrame F = null;
        if (!ok) {
            return new ErrorFrame(err);
        }
        F = new VinciFrame();
        F.fadd("STATUS", "OK");
        return F;
    }

    public static String strip(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        return s;
    }

    public static String emptyString(String s) {
        if (VNS.strip(s) == null) {
            return "";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logRequest(String type, String ip, String text) {
        if (ip == null && (ip = BaseServerRunnable.getSocket().getInetAddress().getHostAddress()) == null) {
            ip = "UNKNOWN";
        }
        if (text == null) {
            text = "";
        }
        Hashtable hashtable = this.hits;
        synchronized (hashtable) {
            Integer I = (Integer)this.hits.get(type);
            if (I == null) {
                I = 0;
            }
            I = I + 1;
            this.hits.put(type, I);
            ++this.totalhits;
        }
        String ts = new Date().toString();
        String write_me = ip + " - [" + ts + "] " + type + " " + text + "\n";
        Debug.p(write_me);
        if (this.log == null) {
            return;
        }
        Writer writer = this.log;
        synchronized (writer) {
            try {
                this.log.write(write_me);
            }
            catch (IOException e) {
                Debug.reportException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanExit() {
        Debug.p("Exiting now ...");
        quitFile.delete();
        try {
            this.backupThreadRunnable.stop = true;
            this.backupThread.interrupt();
        }
        catch (Exception e) {
            Debug.reportException(e);
        }
        this.backupThreadRunnable.forceWrite();
        if (this.log != null) {
            try {
                Writer e = this.log;
                synchronized (e) {
                    this.log.close();
                }
            }
            catch (IOException e) {
                Debug.reportException(e);
            }
        }
    }

    static {
        logFile = null;
        configDir = null;
        backupInterval = 120;
        srvPort = 9000;
        logFlag = false;
        bindAddress = null;
        backlog = 100;
        maxThreads = 200;
    }
}

