/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.uima.adapter.soap.XmlDeserializerFactory;
import org.apache.uima.adapter.soap.XmlSerializerFactory;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.ResourceServiceStub;
import org.apache.uima.resource.metadata.ResourceMetaData;

public abstract class AxisResourceServiceStub
implements ResourceServiceStub {
    private URL mEndpoint;
    private Integer mTimeout;

    public AxisResourceServiceStub(String aEndpoint, Integer aTimeout) throws MalformedURLException {
        this.mEndpoint = new URL(aEndpoint);
        this.mTimeout = aTimeout;
    }

    public ResourceMetaData callGetMetaData() throws ResourceServiceException {
        QName operationQName = new QName("http://uima.apache.org/resource", "getMetaData");
        QName resourceMetaDataTypeQName = new QName("http://uima.apache.org/resourceSpecifier", "resourceMetaData");
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTimeout(this.getTimeout());
            call.setTargetEndpointAddress(this.mEndpoint);
            call.setOperationName(operationQName);
            call.registerTypeMapping(ResourceMetaData.class, resourceMetaDataTypeQName, (SerializerFactory)new XmlSerializerFactory(), (DeserializerFactory)new XmlDeserializerFactory());
            return (ResourceMetaData)call.invoke(new Object[0]);
        }
        catch (ServiceException e) {
            throw new ResourceServiceException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new ResourceServiceException((Throwable)e);
        }
    }

    public URL getServiceEndpoint() {
        return this.mEndpoint;
    }

    public Integer getTimeout() {
        return this.mTimeout;
    }
}

