/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Meter;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class ThresholdMeter
implements Meter {
    private static final double MILLISECONDS_PER_SECOND = 1000.0;
    private final Clock clock;
    private final double maxEventsPerInterval;
    private final Duration interval;
    @GuardedBy(value="this")
    private final Queue<Long> eventTimestamps;
    @GuardedBy(value="this")
    private long eventCount = 0L;

    public ThresholdMeter(double maxEventsPerInterval, Duration interval) {
        this(maxEventsPerInterval, interval, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    public ThresholdMeter(double maxEventsPerInterval, Duration interval, Clock clock) {
        this.clock = clock;
        this.maxEventsPerInterval = maxEventsPerInterval;
        this.interval = interval;
        this.eventTimestamps = new ArrayDeque<Long>();
        if (interval.isNegative() || interval.isZero()) {
            throw new IllegalArgumentException("The threshold interval should be larger than 0.");
        }
    }

    public synchronized void markEvent() {
        this.eventTimestamps.add(this.clock.absoluteTimeMillis());
        ++this.eventCount;
    }

    public synchronized void markEvent(long n) {
        long timestamp = this.clock.absoluteTimeMillis();
        int i = 0;
        while ((long)i < n) {
            this.eventTimestamps.add(timestamp);
            ++i;
        }
        this.eventCount += n;
    }

    public double getRate() {
        return (double)this.getEventCountsRecentInterval() / ((double)this.interval.toMillis() / 1000.0);
    }

    public synchronized long getCount() {
        return this.eventCount;
    }

    public void checkAgainstThreshold() throws ThresholdExceedException {
        int recentEvents = this.getEventCountsRecentInterval();
        if ((double)recentEvents >= this.maxEventsPerInterval) {
            throw new ThresholdExceedException(String.format("%d events detected in the recent interval, reaching the threshold %f.", recentEvents, this.maxEventsPerInterval));
        }
    }

    private synchronized int getEventCountsRecentInterval() {
        Long currentTimeStamp = this.clock.absoluteTimeMillis();
        while (!this.eventTimestamps.isEmpty() && currentTimeStamp - this.eventTimestamps.peek() > this.interval.toMillis()) {
            this.eventTimestamps.remove();
        }
        return this.eventTimestamps.size();
    }

    public static class ThresholdExceedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ThresholdExceedException(String message) {
            super(message);
        }
    }
}

