/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarType;
import org.apache.seatunnel.engine.core.serializable.JobDataSerializerHook;

public class CommonPluginJar
extends ConnectorJar {
    public CommonPluginJar() {
    }

    protected CommonPluginJar(byte[] data, String fileName) {
        super(ConnectorJarType.COMMON_PLUGIN_JAR, data, fileName);
    }

    protected CommonPluginJar(byte[] connectorJarID, byte[] data, String fileName) {
        super(connectorJarID, ConnectorJarType.COMMON_PLUGIN_JAR, data, fileName);
    }

    @Override
    public int getFactoryId() {
        return JobDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByteArray(this.connectorJarID);
        out.writeInt(ConnectorJarType.COMMON_PLUGIN_JAR.ordinal());
        out.writeByteArray(this.data);
        out.writeString(this.fileName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.connectorJarID = in.readByteArray();
        int ordinal = in.readInt();
        ConnectorJarType[] values = ConnectorJarType.values();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new InvalidObjectException("Invalid ordinal for ConnectorJarType");
        }
        this.type = values[ordinal];
        this.data = in.readByteArray();
        this.fileName = in.readString();
    }
}

