/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.config.sql;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.utils.ParserException;
import org.apache.seatunnel.config.sql.ConfigTemplate;
import org.apache.seatunnel.config.sql.model.BaseConfig;
import org.apache.seatunnel.config.sql.model.Option;
import org.apache.seatunnel.config.sql.model.SeaTunnelConfig;
import org.apache.seatunnel.config.sql.model.SinkConfig;
import org.apache.seatunnel.config.sql.model.SourceConfig;
import org.apache.seatunnel.config.sql.model.TransformConfig;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(SqlConfigBuilder.class);

    public static Config of(@NonNull Path sqlFilePath) {
        if (sqlFilePath == null) {
            throw new NullPointerException("sqlFilePath is marked non-null but is null");
        }
        try {
            List<String> lines = Files.readAllLines(sqlFilePath);
            LinkedHashMap<String, BaseConfig> sqlTables = new LinkedHashMap<String, BaseConfig>();
            SeaTunnelConfig seaTunnelConfig = new SeaTunnelConfig();
            List<String> sqlLines = SqlConfigBuilder.parseAnnoConfigAndSqlLine(lines, seaTunnelConfig);
            List<String> sqlList = SqlConfigBuilder.split4SqlList(sqlLines);
            Iterator<String> it = sqlList.iterator();
            while (it.hasNext()) {
                CreateTable createTable;
                String sql = it.next();
                Statement statement = CCJSqlParserUtil.parse(sql);
                if (!(statement instanceof CreateTable) || (createTable = (CreateTable)statement).getTableOptionsStrings() == null) continue;
                SqlConfigBuilder.parseCreateTableSql(createTable, sqlTables, seaTunnelConfig);
                it.remove();
            }
            AtomicInteger tempTableIndex = new AtomicInteger(1);
            for (String sql : sqlList) {
                Statement statement = CCJSqlParserUtil.parse(sql);
                if (statement instanceof CreateTable) {
                    CreateTable createTable = (CreateTable)statement;
                    TransformConfig transformConfig = SqlConfigBuilder.parseCreateAsSql(createTable, sqlTables);
                    seaTunnelConfig.getTransformConfigs().add(transformConfig);
                    continue;
                }
                if (statement instanceof Insert) {
                    SqlConfigBuilder.parseInsertSql((Insert)statement, sqlTables, seaTunnelConfig, tempTableIndex);
                    continue;
                }
                throw new ParserException(String.format("Unsupported SQL syntax: %s", statement));
            }
            seaTunnelConfig.setSinkConfigs(seaTunnelConfig.getSinkConfigs().stream().filter(sinkConfig -> {
                boolean containSourceTable = false;
                for (Option option : sinkConfig.getOptions()) {
                    if (!option.getKey().equals("source_table_name")) continue;
                    containSourceTable = true;
                    break;
                }
                return containSourceTable;
            }).collect(Collectors.toList()));
            if (seaTunnelConfig.getSourceConfigs().isEmpty()) {
                throw new ParserException("The SQL config must contain at least one source table");
            }
            if (seaTunnelConfig.getSinkConfigs().isEmpty()) {
                throw new ParserException("The SQL config must contain `INSERT INTO ... SELECT ...` syntax");
            }
            String configContent = ConfigTemplate.generate(seaTunnelConfig);
            log.debug("Generated config: \n{}", (Object)configContent);
            return ConfigFactory.parseString(configContent);
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    private static List<String> parseAnnoConfigAndSqlLine(List<String> lines, SeaTunnelConfig seaTunnelConfig) {
        ArrayList<String> sqlLines = new ArrayList<String>();
        ArrayList<String> annotationConfigs = new ArrayList<String>();
        boolean annoConfig = false;
        boolean anno = false;
        StringJoiner annotationConfig = new StringJoiner("\n");
        for (String line : lines) {
            if (line.trim().startsWith("--")) continue;
            if (line.trim().equals("/* config")) {
                annoConfig = true;
                continue;
            }
            if (line.trim().startsWith("/*")) {
                anno = true;
                continue;
            }
            if (anno) {
                if (!line.trim().equals("*/")) continue;
                anno = false;
                continue;
            }
            if (annoConfig) {
                if (line.trim().equals("*/")) {
                    annoConfig = false;
                    annotationConfigs.add(annotationConfig.toString());
                    annotationConfig = new StringJoiner("\n");
                    continue;
                }
                annotationConfig.add(line);
                continue;
            }
            if (!StringUtils.isNotEmpty(line.trim())) continue;
            sqlLines.add(line);
        }
        seaTunnelConfig.getEnvConfigs().addAll(annotationConfigs);
        return sqlLines;
    }

    private static List<String> split4SqlList(List<String> sqlLines) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringJoiner sqlSj = new StringJoiner(" ");
        for (String line : sqlLines) {
            int commentIdx = (line = line.trim()).indexOf(" --");
            if (commentIdx > -1) {
                line = line.substring(0, commentIdx);
            }
            if (line.endsWith(";")) {
                line = line.substring(0, line.length() - 1);
                sqlSj.add(line);
                sqlList.add(sqlSj.toString());
                sqlSj = new StringJoiner(" ");
                continue;
            }
            sqlSj.add(line);
        }
        return sqlList;
    }

    private static void parseCreateTableSql(CreateTable createTable, Map<String, BaseConfig> sqlTables, SeaTunnelConfig seaTunnelConfig) {
        Map<String, String> optionsMap = SqlConfigBuilder.parseOptions(createTable);
        String tableName = createTable.getTable().getName();
        if (sqlTables.containsKey(tableName)) {
            throw new ParserException(String.format("Table name duplicate: %s", tableName));
        }
        String type = optionsMap.get("type");
        if ("source".equalsIgnoreCase(type)) {
            SourceConfig sourceConfig = SqlConfigBuilder.parseSourceSql(createTable, optionsMap);
            sqlTables.put(tableName, sourceConfig);
            seaTunnelConfig.getSourceConfigs().add(sourceConfig);
        } else if ("sink".equalsIgnoreCase(type)) {
            SinkConfig sinkConfig = SqlConfigBuilder.parseSinkSql(optionsMap);
            sqlTables.put(tableName, sinkConfig);
            seaTunnelConfig.getSinkConfigs().add(sinkConfig);
        }
    }

    private static Map<String, String> parseOptions(CreateTable createTable) {
        String options = createTable.getTableOptionsStrings().get(1);
        options = options.substring(0, options.length() - 1).substring(1);
        String[] optionItems = options.split(",'");
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        for (String optionItem : optionItems) {
            int idx = optionItem.indexOf("=");
            if (idx < 0) continue;
            String key = SqlConfigBuilder.clean(optionItem.substring(0, idx).trim());
            String value = SqlConfigBuilder.clean(optionItem.substring(idx + 1).trim());
            optionsMap.put(key, value);
        }
        return optionsMap;
    }

    private static SourceConfig parseSourceSql(CreateTable createTable, Map<String, String> options) {
        String connector = options.get("connector");
        if (StringUtils.isEmpty(connector)) {
            throw new ParserException("The connector of option is none");
        }
        SourceConfig sourceConfig = new SourceConfig();
        sourceConfig.setConnector(connector);
        String resultTableName = createTable.getTable().getName();
        sourceConfig.setResultTableName(resultTableName);
        SqlConfigBuilder.convertOptions(options, sourceConfig.getOptions());
        sourceConfig.getOptions().add(Option.of("result_table_name", "\"" + resultTableName + "\""));
        return sourceConfig;
    }

    private static SinkConfig parseSinkSql(Map<String, String> options) {
        String connector = options.get("connector");
        if (StringUtils.isEmpty(connector)) {
            throw new ParserException("The connector of option is none");
        }
        SinkConfig sinkConfig = new SinkConfig();
        sinkConfig.setConnector(connector);
        options.remove("source_table_name");
        SqlConfigBuilder.convertOptions(options, sinkConfig.getOptions());
        return sinkConfig;
    }

    private static void convertOptions(Map<String, String> options, Collection<Option> optionList) {
        options.forEach((k, v) -> {
            if ("connector".equalsIgnoreCase((String)k) || "type".equalsIgnoreCase((String)k) || "result_table_name".equalsIgnoreCase((String)k)) {
                return;
            }
            String trimVal = v.trim();
            if (!(trimVal.startsWith("{") && trimVal.endsWith("}") || trimVal.startsWith("[") && trimVal.endsWith("]"))) {
                v = "\"" + v + "\"";
            }
            Option option = Option.of(k, v);
            optionList.add(option);
        });
    }

    private static TransformConfig parseCreateAsSql(CreateTable createTable, Map<String, BaseConfig> sqlTables) {
        Select select = createTable.getSelect();
        if (select != null) {
            TransformConfig transformConfig = new TransformConfig();
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            Table table = (Table)plainSelect.getFromItem();
            String sourceTableName = table.getName();
            if (!sqlTables.containsKey(sourceTableName)) {
                throw new ParserException(String.format("The source table[%s] is not found", sourceTableName));
            }
            String resultTableName = createTable.getTable().getName();
            if (sqlTables.containsKey(resultTableName)) {
                throw new ParserException(String.format("Table name duplicate: %s", resultTableName));
            }
            sqlTables.put(resultTableName, transformConfig);
            String query = select.toString();
            transformConfig.setSourceTableName(sourceTableName);
            transformConfig.setResultTableName(resultTableName);
            transformConfig.setQuery(query);
            return transformConfig;
        }
        throw new ParserException(String.format("Unsupported syntax: %s", createTable));
    }

    private static void parseInsertSql(Insert insertSql, Map<String, BaseConfig> sqlTables, SeaTunnelConfig seaTunnelConfig, AtomicInteger tempTableIndex) {
        String resultTableName;
        if (insertSql.getColumns() != null && !insertSql.getColumns().isEmpty()) {
            throw new ParserException("Insert sql must not have columns");
        }
        TransformConfig transformConfig = new TransformConfig();
        Select select = insertSql.getSelect();
        if (select == null || select.getSelectBody() == null || !(select.getSelectBody() instanceof PlainSelect)) {
            throw new ParserException("Insert sql must have select statement");
        }
        String targetTableName = insertSql.getTable().getName();
        if (select.getSelectBody() instanceof PlainSelect) {
            String sourceTableName;
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            if (plainSelect.getFromItem() == null) {
                List<SelectItem> selectItems = plainSelect.getSelectItems();
                if (selectItems.size() != 1) {
                    throw new ParserException("Source table must be specified in SQL: " + insertSql);
                }
                SelectExpressionItem selectItem = (SelectExpressionItem)selectItems.get(0);
                Column column = (Column)selectItem.getExpression();
                resultTableName = sourceTableName = column.getColumnName();
            } else {
                if (!(plainSelect.getFromItem() instanceof Table)) {
                    throw new ParserException("Unsupported syntax: " + insertSql);
                }
                Table table = (Table)plainSelect.getFromItem();
                sourceTableName = table.getName();
                resultTableName = sourceTableName + "__temp" + tempTableIndex.getAndIncrement();
                String query = select.toString();
                transformConfig.setSourceTableName(sourceTableName);
                transformConfig.setResultTableName(resultTableName);
                transformConfig.setQuery(query);
                seaTunnelConfig.getTransformConfigs().add(transformConfig);
            }
            if (!sqlTables.containsKey(sourceTableName) || !"source".equalsIgnoreCase(sqlTables.get(sourceTableName).getType()) && !"transform".equalsIgnoreCase(sqlTables.get(sourceTableName).getType())) {
                throw new ParserException(String.format("The source table[%s] is not found", sourceTableName));
            }
            if (!sqlTables.containsKey(targetTableName) || !"sink".equalsIgnoreCase(sqlTables.get(targetTableName).getType())) {
                throw new ParserException(String.format("The sink table[%s] is not found", sourceTableName));
            }
        } else {
            throw new ParserException("Unsupported syntax: " + insertSql);
        }
        SinkConfig sinkConfig = (SinkConfig)sqlTables.get(targetTableName);
        SinkConfig sinkConfigNew = new SinkConfig();
        sinkConfigNew.setConnector(sinkConfig.getConnector());
        sinkConfigNew.setSourceTableName(resultTableName);
        sinkConfigNew.getOptions().addAll(sinkConfig.getOptions());
        sinkConfigNew.getOptions().add(Option.of("source_table_name", "\"" + resultTableName + "\""));
        seaTunnelConfig.getSinkConfigs().add(sinkConfigNew);
    }

    private static String clean(String val) {
        if (val.startsWith("'")) {
            val = val.substring(1);
        }
        if (val.endsWith("'")) {
            val = val.substring(0, val.length() - 1);
        }
        val = val.replace("''", "'");
        return val;
    }
}

