/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.batch;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.apis.base.env.Execution;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.spark.BaseSparkTransform;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.spark.batch.SparkBatchSink;
import org.apache.seatunnel.spark.batch.SparkBatchSource;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SparkBatchExecution
implements Execution<SparkBatchSource, BaseSparkTransform, SparkBatchSink, SparkEnvironment> {
    private final SparkEnvironment environment;
    private Config config = ConfigFactory.empty();

    public SparkBatchExecution(SparkEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public void start(List<SparkBatchSource> sources, List<BaseSparkTransform> transforms, List<SparkBatchSink> sinks) {
        List sourceDatasets = sources.stream().map(source -> SparkEnvironment.registerInputTempView(source, this.environment)).collect(Collectors.toList());
        if (!sources.isEmpty()) {
            Dataset<Row> ds = (Dataset<Row>)sourceDatasets.get(0);
            for (BaseSparkTransform transform2 : transforms) {
                ds = SparkEnvironment.transformProcess(this.environment, transform2, ds);
                SparkEnvironment.registerTransformTempView(transform2, ds);
            }
            for (SparkBatchSink sink : sinks) {
                SparkEnvironment.sinkProcess(this.environment, sink, ds);
            }
        }
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }
}

