/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.config.DeployMode;
import org.apache.seatunnel.core.starter.Starter;
import org.apache.seatunnel.core.starter.config.ConfigBuilder;
import org.apache.seatunnel.core.starter.config.PluginType;
import org.apache.seatunnel.core.starter.spark.SeatunnelSpark;
import org.apache.seatunnel.core.starter.spark.args.SparkCommandArgs;
import org.apache.seatunnel.core.starter.utils.CommandLineUtils;
import org.apache.seatunnel.core.starter.utils.CompressionUtils;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public class SparkStarter
implements Starter {
    protected String[] args;
    protected SparkCommandArgs commandArgs;
    protected List<Path> jars = new ArrayList<Path>();
    protected List<Path> files = new ArrayList<Path>();
    protected Map<String, String> sparkConf;

    private SparkStarter(String[] args, SparkCommandArgs commandArgs) {
        this.args = args;
        this.commandArgs = commandArgs;
    }

    public static void main(String[] args) throws IOException {
        SparkStarter starter = SparkStarter.getInstance(args);
        List<String> command = starter.buildCommands();
        System.out.println(String.join((CharSequence)" ", command));
    }

    static SparkStarter getInstance(String[] args) {
        SparkCommandArgs commandArgs = CommandLineUtils.parse(args, new SparkCommandArgs(), "start-seatunnel-spark-connector-v2.sh", true);
        DeployMode deployMode = commandArgs.getDeployMode();
        switch (deployMode) {
            case CLUSTER: {
                return new ClusterModeSparkStarter(args, commandArgs);
            }
            case CLIENT: {
                return new ClientModeSparkStarter(args, commandArgs);
            }
        }
        throw new IllegalArgumentException("Deploy mode " + (Object)((Object)deployMode) + " not supported");
    }

    @Override
    public List<String> buildCommands() throws IOException {
        this.setSparkConf();
        Common.setDeployMode(this.commandArgs.getDeployMode());
        Common.setStarter(true);
        this.jars.addAll(Common.getPluginsJarDependencies());
        this.jars.addAll(this.getConnectorJarDependencies());
        return this.buildFinal();
    }

    private void setSparkConf() throws FileNotFoundException {
        this.commandArgs.getVariables().stream().filter(Objects::nonNull).map(variable -> variable.split("=", 2)).filter(pair -> ((String[])pair).length == 2).forEach(pair -> System.setProperty(pair[0], pair[1]));
        this.sparkConf = SparkStarter.getSparkConf(this.commandArgs.getConfigFile());
        String driverJavaOpts = this.sparkConf.getOrDefault("spark.driver.extraJavaOptions", "");
        String executorJavaOpts = this.sparkConf.getOrDefault("spark.executor.extraJavaOptions", "");
        if (!this.commandArgs.getVariables().isEmpty()) {
            String properties = this.commandArgs.getVariables().stream().map(v -> "-D" + v).collect(Collectors.joining(" "));
            driverJavaOpts = driverJavaOpts + " " + properties;
            executorJavaOpts = executorJavaOpts + " " + properties;
            this.sparkConf.put("spark.driver.extraJavaOptions", driverJavaOpts.trim());
            this.sparkConf.put("spark.executor.extraJavaOptions", executorJavaOpts.trim());
        }
    }

    static Map<String, String> getSparkConf(String configFile) throws FileNotFoundException {
        File file = new File(configFile);
        if (!file.exists()) {
            throw new FileNotFoundException("config file '" + file + "' does not exists!");
        }
        Config appConfig = ConfigFactory.parseFile(file).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        return appConfig.getConfig("env").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigValue)e.getValue()).unwrapped().toString()));
    }

    private List<Path> getConnectorJarDependencies() {
        Path pluginRootDir = Common.connectorJarDir("seatunnel");
        if (!Files.exists(pluginRootDir, new LinkOption[0]) || !Files.isDirectory(pluginRootDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Config config = new ConfigBuilder(Paths.get(this.commandArgs.getConfigFile(), new String[0])).getConfig();
        HashSet<URL> pluginJars = new HashSet<URL>();
        SeaTunnelSourcePluginDiscovery seaTunnelSourcePluginDiscovery = new SeaTunnelSourcePluginDiscovery();
        SeaTunnelSinkPluginDiscovery seaTunnelSinkPluginDiscovery = new SeaTunnelSinkPluginDiscovery();
        pluginJars.addAll(seaTunnelSourcePluginDiscovery.getPluginJarPaths(this.getPluginIdentifiers(config, PluginType.SOURCE)));
        pluginJars.addAll(seaTunnelSinkPluginDiscovery.getPluginJarPaths(this.getPluginIdentifiers(config, PluginType.SINK)));
        return pluginJars.stream().map(url -> new File(url.getPath()).toPath()).collect(Collectors.toList());
    }

    protected List<String> buildFinal() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("${SPARK_HOME}/bin/spark-submit");
        this.appendOption(commands, "--class", SeatunnelSpark.class.getName());
        this.appendOption(commands, "--name", this.commandArgs.getJobName());
        this.appendOption(commands, "--master", this.commandArgs.getMaster());
        this.appendOption(commands, "--deploy-mode", this.commandArgs.getDeployMode().getName());
        this.appendJars(commands, this.jars);
        this.appendFiles(commands, this.files);
        this.appendSparkConf(commands, this.sparkConf);
        this.appendAppJar(commands);
        this.appendArgs(commands, this.args);
        return commands;
    }

    protected void appendOption(List<String> commands, String option, String value) {
        commands.add(option);
        commands.add("\"" + value.replace("\"", "\\\"") + "\"");
    }

    protected void appendJars(List<String> commands, List<Path> paths) {
        this.appendPaths(commands, "--jars", paths);
    }

    protected void appendFiles(List<String> commands, List<Path> paths) {
        this.appendPaths(commands, "--files", paths);
    }

    protected void appendPaths(List<String> commands, String option, List<Path> paths) {
        if (!paths.isEmpty()) {
            String values = paths.stream().map(Path::toString).collect(Collectors.joining(","));
            this.appendOption(commands, option, values);
        }
    }

    protected void appendSparkConf(List<String> commands, Map<String, String> sparkConf) {
        for (Map.Entry<String, String> entry : sparkConf.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.appendOption(commands, "--conf", key + "=" + value);
        }
    }

    protected void appendArgs(List<String> commands, String[] args) {
        commands.addAll(Arrays.asList(args));
    }

    protected void appendAppJar(List<String> commands) {
        commands.add(Common.appLibDir().resolve("seatunnel-spark-starter.jar").toString());
    }

    private List<PluginIdentifier> getPluginIdentifiers(Config config, PluginType ... pluginTypes) {
        return Arrays.stream(pluginTypes).flatMap(pluginType -> {
            List<? extends Config> configList = config.getConfigList(pluginType.getType());
            return configList.stream().map(pluginConfig -> PluginIdentifier.of("seatunnel", pluginType.getType(), pluginConfig.getString("plugin_name")));
        }).collect(Collectors.toList());
    }

    private static class ClusterModeSparkStarter
    extends SparkStarter {
        private ClusterModeSparkStarter(String[] args, SparkCommandArgs commandArgs) {
            super(args, commandArgs);
        }

        @Override
        public List<String> buildCommands() throws IOException {
            Common.setDeployMode(this.commandArgs.getDeployMode());
            Common.setStarter(true);
            Path pluginTarball = Common.pluginTarball();
            CompressionUtils.tarGzip(Common.pluginRootDir(), pluginTarball);
            this.files.add(pluginTarball);
            this.files.add(Paths.get(this.commandArgs.getConfigFile(), new String[0]));
            return super.buildCommands();
        }
    }

    private static class ClientModeSparkStarter
    extends SparkStarter {
        private ClientModeSparkStarter(String[] args, SparkCommandArgs commandArgs) {
            super(args, commandArgs);
        }

        @Override
        protected void appendSparkConf(List<String> commands, Map<String, String> sparkConf) {
            for (ClientModeSparkConfigs config : ClientModeSparkConfigs.values()) {
                String driverJavaOptions = (String)this.sparkConf.get(config.propertyName);
                if (!StringUtils.isNotBlank(driverJavaOptions)) continue;
                this.appendOption(commands, config.optionName, driverJavaOptions);
            }
            for (Map.Entry entry : sparkConf.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (ClientModeSparkConfigs.PROPERTY_NAME_MAP.containsKey(key)) continue;
                this.appendOption(commands, "--conf", key + "=" + value);
            }
        }

        private static enum ClientModeSparkConfigs {
            DriverMemory("--driver-memory", "spark.driver.memory"),
            DriverJavaOptions("--driver-java-options", "spark.driver.extraJavaOptions"),
            DriverLibraryPath(" --driver-library-path", "spark.driver.extraLibraryPath"),
            DriverClassPath("--driver-class-path", "spark.driver.extraClassPath");

            private final String optionName;
            private final String propertyName;
            private static final Map<String, ClientModeSparkConfigs> PROPERTY_NAME_MAP;

            private ClientModeSparkConfigs(String optionName, String propertyName) {
                this.optionName = optionName;
                this.propertyName = propertyName;
            }

            static {
                PROPERTY_NAME_MAP = new HashMap<String, ClientModeSparkConfigs>();
                for (ClientModeSparkConfigs config : ClientModeSparkConfigs.values()) {
                    PROPERTY_NAME_MAP.put(config.propertyName, config);
                }
            }
        }
    }
}

