/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;

public class CheckpointFinishedOperation
extends TaskOperation {
    private long checkpointId;
    private boolean successful;

    public CheckpointFinishedOperation(TaskLocation taskLocation, long checkpointId, boolean successful) {
        super(taskLocation);
        this.checkpointId = checkpointId;
        this.successful = successful;
    }

    @Override
    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.checkpointId);
        out.writeBoolean(this.successful);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.checkpointId = in.readLong();
        this.successful = in.readBoolean();
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            Object task = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation()).getTaskGroup().getTask(this.taskLocation.getTaskID());
            try {
                if (this.successful) {
                    task.notifyCheckpointComplete(this.checkpointId);
                } else {
                    task.notifyCheckpointAborted(this.checkpointId);
                }
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
            return null;
        }, new RetryUtils.RetryMaterial(5, true, exception -> exception instanceof NullPointerException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public CheckpointFinishedOperation() {
    }
}

