/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.Node;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.NodeExtensionCommon;
import org.apache.seatunnel.engine.server.SeaTunnelServer;

public class NodeExtension
extends DefaultNodeExtension {
    private final NodeExtensionCommon extCommon;

    public NodeExtension(@NonNull Node node, @NonNull SeaTunnelConfig seaTunnelConfig) {
        super(node);
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked @NonNull but is null");
        }
        this.extCommon = new NodeExtensionCommon(node, new SeaTunnelServer(seaTunnelConfig));
    }

    @Override
    public void beforeStart() {
        super.beforeStart();
    }

    @Override
    public void afterStart() {
        super.afterStart();
        this.extCommon.afterStart();
    }

    @Override
    public void beforeClusterStateChange(ClusterState currState, ClusterState requestedState, boolean isTransient) {
        super.beforeClusterStateChange(currState, requestedState, isTransient);
        this.extCommon.beforeClusterStateChange(requestedState);
    }

    @Override
    public void onClusterStateChange(ClusterState newState, boolean isTransient) {
        super.onClusterStateChange(newState, isTransient);
        this.extCommon.onClusterStateChange(newState);
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        return this.extCommon.createExtensionServices();
    }

    @Override
    public void printNodeInfo() {
        this.extCommon.printNodeInfo(this.systemLogger, "");
    }
}

