/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.exception.JobException;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.RunningJobInfo;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManagerFactory;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;

public class CoordinatorService {
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private volatile ResourceManager resourceManager;
    private IMap<Long, RunningJobInfo> runningJobInfoIMap;
    IMap<Object, Object> runningJobStateIMap;
    IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private Map<Long, JobMaster> runningJobMasterMap = new ConcurrentHashMap<Long, JobMaster>();
    private IMap<PipelineLocation, Map<TaskGroupLocation, SlotProfile>> ownedSlotProfilesIMap;
    private volatile boolean isActive = false;
    private final ExecutorService executorService;
    private final SeaTunnelServer seaTunnelServer;
    private ScheduledExecutorService masterActiveListener;
    private final EngineConfig engineConfig;

    public CoordinatorService(@NonNull NodeEngineImpl nodeEngine, @NonNull SeaTunnelServer seaTunnelServer, EngineConfig engineConfig) {
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked @NonNull but is null");
        }
        if (seaTunnelServer == null) {
            throw new NullPointerException("seaTunnelServer is marked @NonNull but is null");
        }
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("seatunnel-coordinator-service-%d").build());
        this.seaTunnelServer = seaTunnelServer;
        this.engineConfig = engineConfig;
        this.masterActiveListener = Executors.newSingleThreadScheduledExecutor();
        this.masterActiveListener.scheduleAtFixedRate(this::checkNewActiveMaster, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public JobMaster getJobMaster(Long jobId) {
        return this.runningJobMasterMap.get(jobId);
    }

    private void initCoordinatorService() {
        this.runningJobInfoIMap = this.nodeEngine.getHazelcastInstance().getMap("runningJobInfo");
        this.runningJobStateIMap = this.nodeEngine.getHazelcastInstance().getMap("runningJobState");
        this.runningJobStateTimestampsIMap = this.nodeEngine.getHazelcastInstance().getMap("stateTimestamps");
        this.ownedSlotProfilesIMap = this.nodeEngine.getHazelcastInstance().getMap("ownedSlotProfilesIMap");
        List<CompletableFuture> collect2 = this.runningJobInfoIMap.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> {
            this.logger.info(String.format("begin restore job (%s) from master active switch", entry.getKey()));
            this.restoreJobFromMasterActiveSwitch((Long)entry.getKey(), (RunningJobInfo)entry.getValue());
            this.logger.info(String.format("restore job (%s) from master active switch finished", entry.getKey()));
        }, this.executorService)).collect(Collectors.toList());
        try {
            CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(collect2.toArray(new CompletableFuture[0]));
            voidCompletableFuture.get();
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException(e);
        }
    }

    private void restoreJobFromMasterActiveSwitch(@NonNull Long jobId, @NonNull RunningJobInfo runningJobInfo) {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked @NonNull but is null");
        }
        if (runningJobInfo == null) {
            throw new NullPointerException("runningJobInfo is marked @NonNull but is null");
        }
        if (this.runningJobStateIMap.get(jobId) == null) {
            this.runningJobInfoIMap.remove(jobId);
            return;
        }
        JobStatus jobStatus = (JobStatus)((Object)this.runningJobStateIMap.get(jobId));
        JobMaster jobMaster = new JobMaster(runningJobInfo.getJobImmutableInformation(), this.nodeEngine, this.executorService, this.getResourceManager(), this.runningJobStateIMap, this.runningJobStateTimestampsIMap, this.ownedSlotProfilesIMap, this.engineConfig);
        try {
            jobMaster.init(this.runningJobInfoIMap.get(jobId).getInitializationTimestamp());
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException(String.format("Job id %s init JobMaster failed", jobId), e);
        }
        String jobFullName = jobMaster.getPhysicalPlan().getJobFullName();
        if (jobStatus.isEndState()) {
            this.logger.info(String.format("The restore %s is in an end state %s, store the job info to JobHistory and clear the job running time info", new Object[]{jobFullName, jobStatus}));
            this.removeJobIMap(jobMaster);
            return;
        }
        if (jobStatus.ordinal() < JobStatus.RUNNING.ordinal()) {
            this.logger.info(String.format("The restore %s is state %s, cancel job and submit it again.", new Object[]{jobFullName, jobStatus}));
            jobMaster.cancelJob();
            jobMaster.getJobMasterCompleteFuture().join();
            this.submitJob(jobId, runningJobInfo.getJobImmutableInformation()).join();
            return;
        }
        this.runningJobMasterMap.put(jobId, jobMaster);
        jobMaster.markRestore();
        if (JobStatus.CANCELLING.equals((Object)jobStatus)) {
            this.logger.info(String.format("The restore %s is in %s state, cancel the job", new Object[]{jobFullName, jobStatus}));
            CompletableFuture.runAsync(() -> {
                try {
                    jobMaster.cancelJob();
                    jobMaster.run();
                }
                finally {
                    this.removeJobIMap(jobMaster);
                    this.runningJobMasterMap.remove(jobId);
                }
            });
            return;
        }
        if (JobStatus.RUNNING.equals((Object)jobStatus)) {
            this.logger.info(String.format("The restore %s is in %s state, restore pipeline and take over this job running", new Object[]{jobFullName, jobStatus}));
            CompletableFuture.runAsync(() -> {
                try {
                    jobMaster.getPhysicalPlan().getPipelineList().forEach(SubPlan::restorePipelineState);
                    jobMaster.run();
                }
                finally {
                    this.removeJobIMap(jobMaster);
                    this.runningJobMasterMap.remove(jobId);
                }
            });
            return;
        }
    }

    private void checkNewActiveMaster() {
        try {
            if (!this.isActive && this.seaTunnelServer.isMasterNode()) {
                this.logger.info("This node become a new active master node, begin init coordinator service");
                this.initCoordinatorService();
                this.isActive = true;
            } else if (this.isActive && !this.seaTunnelServer.isMasterNode()) {
                this.isActive = false;
                this.logger.info("This node become leave active master node, begin clear coordinator service");
                this.clearCoordinatorService();
            }
        }
        catch (Exception e) {
            this.isActive = false;
            this.logger.severe(ExceptionUtils.getMessage(e));
            throw new SeaTunnelEngineException("check new active master error, stop loop", e);
        }
    }

    private void clearCoordinatorService() {
        this.runningJobMasterMap.values().forEach(JobMaster::interrupt);
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
            this.runningJobMasterMap = new ConcurrentHashMap<Long, JobMaster>();
        }
        catch (InterruptedException e) {
            throw new SeaTunnelEngineException("wait clean executor service error", e);
        }
        if (this.resourceManager != null) {
            this.resourceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            CoordinatorService coordinatorService = this;
            synchronized (coordinatorService) {
                if (this.resourceManager == null) {
                    ResourceManager manager = new ResourceManagerFactory(this.nodeEngine).getResourceManager();
                    manager.init();
                    this.resourceManager = manager;
                }
            }
        }
        return this.resourceManager;
    }

    public PassiveCompletableFuture<Void> submitJob(long jobId, Data jobImmutableInformation) {
        CompletableFuture voidCompletableFuture = new CompletableFuture();
        JobMaster jobMaster = new JobMaster(jobImmutableInformation, this.nodeEngine, this.executorService, this.getResourceManager(), this.runningJobStateIMap, this.runningJobStateTimestampsIMap, this.ownedSlotProfilesIMap, this.engineConfig);
        this.executorService.submit(() -> {
            try {
                this.runningJobInfoIMap.put(jobId, new RunningJobInfo(System.currentTimeMillis(), jobImmutableInformation));
                this.runningJobMasterMap.put(jobId, jobMaster);
                jobMaster.init(this.runningJobInfoIMap.get(jobId).getInitializationTimestamp());
            }
            catch (Throwable e) {
                this.logger.severe(String.format("submit job %s error %s ", jobId, ExceptionUtils.getMessage(e)));
                voidCompletableFuture.completeExceptionally(e);
            }
            finally {
                voidCompletableFuture.complete(null);
            }
            try {
                jobMaster.run();
            }
            finally {
                this.removeJobIMap(jobMaster);
                this.runningJobMasterMap.remove(jobId);
            }
        });
        return new PassiveCompletableFuture<Void>(voidCompletableFuture);
    }

    private void removeJobIMap(JobMaster jobMaster) {
        Long jobId = jobMaster.getJobImmutableInformation().getJobId();
        this.runningJobStateTimestampsIMap.remove(jobId);
        jobMaster.getPhysicalPlan().getPipelineList().forEach(pipeline -> {
            this.runningJobStateIMap.remove(pipeline.getPipelineLocation());
            this.runningJobStateTimestampsIMap.remove(pipeline.getPipelineLocation());
            pipeline.getCoordinatorVertexList().forEach(coordinator -> {
                this.runningJobStateIMap.remove(coordinator.getTaskGroupLocation());
                this.runningJobStateTimestampsIMap.remove(coordinator.getTaskGroupLocation());
            });
            pipeline.getPhysicalVertexList().forEach(task -> {
                this.runningJobStateIMap.remove(task.getTaskGroupLocation());
                this.runningJobStateTimestampsIMap.remove(task.getTaskGroupLocation());
            });
        });
        this.runningJobStateIMap.remove(jobId);
        this.runningJobInfoIMap.remove(jobId);
    }

    public PassiveCompletableFuture<JobStatus> waitForJobComplete(long jobId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jobId);
        if (runningJobMaster == null) {
            CompletableFuture<JobStatus> future = new CompletableFuture<JobStatus>();
            future.complete(JobStatus.FINISHED);
            return new PassiveCompletableFuture<JobStatus>(future);
        }
        return runningJobMaster.getJobMasterCompleteFuture();
    }

    public PassiveCompletableFuture<Void> cancelJob(long jodId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jodId);
        if (runningJobMaster == null) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.complete(null);
            return new PassiveCompletableFuture<Void>(future);
        }
        return new PassiveCompletableFuture<Void>(CompletableFuture.supplyAsync(() -> {
            runningJobMaster.cancelJob();
            return null;
        }, this.executorService));
    }

    public JobStatus getJobStatus(long jobId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jobId);
        if (runningJobMaster == null) {
            return JobStatus.FINISHED;
        }
        return runningJobMaster.getJobStatus();
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        TaskGroupLocation taskGroupLocation = taskExecutionState.getTaskGroupLocation();
        JobMaster runningJobMaster = this.runningJobMasterMap.get(taskGroupLocation.getJobId());
        if (runningJobMaster == null) {
            throw new JobException(String.format("Job %s not running", taskGroupLocation.getJobId()));
        }
        runningJobMaster.updateTaskExecutionState(taskExecutionState);
    }

    public void shutdown() {
        if (this.masterActiveListener != null) {
            this.masterActiveListener.shutdownNow();
        }
        this.clearCoordinatorService();
    }

    public boolean isCoordinatorActive() {
        return this.isActive;
    }

    public void failedTaskOnMemberRemoved(MembershipServiceEvent event) {
        Address lostAddress = event.getMember().getAddress();
        this.runningJobMasterMap.forEach((aLong, jobMaster) -> jobMaster.getPhysicalPlan().getPipelineList().forEach(subPlan -> {
            this.makeTasksFailed(subPlan.getCoordinatorVertexList(), lostAddress);
            this.makeTasksFailed(subPlan.getPhysicalVertexList(), lostAddress);
        }));
    }

    private void makeTasksFailed(@NonNull List<PhysicalVertex> physicalVertexList, @NonNull Address lostAddress) {
        if (physicalVertexList == null) {
            throw new NullPointerException("physicalVertexList is marked @NonNull but is null");
        }
        if (lostAddress == null) {
            throw new NullPointerException("lostAddress is marked @NonNull but is null");
        }
        physicalVertexList.forEach(physicalVertex -> {
            Address deployAddress = physicalVertex.getCurrentExecutionAddress();
            ExecutionState executionState = physicalVertex.getExecutionState();
            if (null != deployAddress && deployAddress.equals(lostAddress) && (executionState.equals(ExecutionState.DEPLOYING) || executionState.equals(ExecutionState.RUNNING) || executionState.equals(ExecutionState.CANCELING))) {
                TaskGroupLocation taskGroupLocation = physicalVertex.getTaskGroupLocation();
                physicalVertex.updateTaskExecutionState(new TaskExecutionState(taskGroupLocation, ExecutionState.FAILED, new JobException(String.format("The taskGroup(%s) deployed node(%s) offline", taskGroupLocation, lostAddress))));
            }
        });
    }

    public void memberRemoved(MembershipServiceEvent event) {
        this.getResourceManager().memberRemoved(event);
        this.failedTaskOnMemberRemoved(event);
    }

    public void printExecutionInfo() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executorService;
        int activeCount = threadPoolExecutor.getActiveCount();
        int corePoolSize = threadPoolExecutor.getCorePoolSize();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        int poolSize = threadPoolExecutor.getPoolSize();
        long completedTaskCount = threadPoolExecutor.getCompletedTaskCount();
        long taskCount = threadPoolExecutor.getTaskCount();
        StringBuffer sbf = new StringBuffer();
        sbf.append("activeCount=").append(activeCount).append("\n").append("corePoolSize=").append(corePoolSize).append("\n").append("maximumPoolSize=").append(maximumPoolSize).append("\n").append("poolSize=").append(poolSize).append("\n").append("completedTaskCount=").append(completedTaskCount).append("\n").append("taskCount=").append(taskCount);
        this.logger.info(sbf.toString());
    }
}

