/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.CodedInput;
import io.protostuff.FilterInput;
import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.UninitializedMessageException;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.util.ArrayList;

public final class GraphCodedInput
extends FilterInput<CodedInput>
implements GraphInput,
Schema<Object> {
    private final ArrayList<Object> references;
    private int lastRef = -1;
    private Schema<Object> lastSchema;
    private boolean messageReference = false;

    public GraphCodedInput(CodedInput input2) {
        super(input2);
        assert (input2.decodeNestedMessageAsGroup);
        this.references = new ArrayList();
    }

    public GraphCodedInput(CodedInput input2, int initialCapacity) {
        super(input2);
        assert (input2.decodeNestedMessageAsGroup);
        this.references = new ArrayList(initialCapacity);
    }

    @Override
    public void updateLast(Object morphedMessage, Object lastMessage) {
        int last2 = this.references.size() - 1;
        if (lastMessage != null && lastMessage == this.references.get(last2)) {
            this.references.set(last2, morphedMessage);
        }
    }

    @Override
    public boolean isCurrentMessageReference() {
        return this.messageReference;
    }

    @Override
    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        int fieldNumber = ((CodedInput)this.input).readFieldNumber(schema);
        if (WireFormat.getTagWireType(((CodedInput)this.input).getLastTag()) == 6) {
            this.lastRef = ((CodedInput)this.input).readUInt32();
            this.messageReference = true;
        } else {
            this.messageReference = false;
        }
        return fieldNumber;
    }

    @Override
    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.messageReference) {
            return (T)this.references.get(this.lastRef);
        }
        this.lastSchema = schema;
        if (value == null) {
            value = schema.newMessage();
        }
        this.references.add(value);
        ((CodedInput)this.input).mergeObject(value, this);
        return value;
    }

    @Override
    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        if (!this.messageReference) {
            ((CodedInput)this.input).skipField(((CodedInput)this.input).getLastTag());
        }
    }

    @Override
    public String getFieldName(int number) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFieldNumber(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInitialized(Object owner) {
        return true;
    }

    @Override
    public String messageFullName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String messageName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<? super Object> typeClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mergeFrom(Input input2, Object message) throws IOException {
        Schema<Object> schema = this.lastSchema;
        schema.mergeFrom(this, message);
        if (!schema.isInitialized(message)) {
            throw new UninitializedMessageException(message, schema);
        }
        this.lastSchema = schema;
    }

    @Override
    public void writeTo(Output output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }
}

