/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.timeout;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class DefaultIdleStateEvent
implements IdleStateEvent {
    private final Channel channel;
    private final IdleState state;
    private final long lastActivityTimeMillis;

    public DefaultIdleStateEvent(Channel channel, IdleState state2, long lastActivityTimeMillis) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (state2 == null) {
            throw new NullPointerException("state");
        }
        this.channel = channel;
        this.state = state2;
        this.lastActivityTimeMillis = lastActivityTimeMillis;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public IdleState getState() {
        return this.state;
    }

    public long getLastActivityTimeMillis() {
        return this.lastActivityTimeMillis;
    }

    public String toString() {
        return this.getChannel().toString() + ' ' + (Object)((Object)this.getState()) + " since " + DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date(this.getLastActivityTimeMillis()));
    }
}

