/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.hadoop.hbase.util.Pair;

public class BigDecimalUtil {
    public static Pair<Integer, Integer> getResultPrecisionScale(int lp, int ls, int rp, int rs, Operation op) {
        int resultPrec = 0;
        int resultScale = 0;
        switch (op) {
            case MULTIPLY: {
                resultPrec = lp + rp;
                resultScale = ls + rs;
                break;
            }
            case DIVIDE: {
                resultPrec = lp - ls + rp + Math.max(ls + rp - rs + 1, 4);
                resultScale = 31 - lp + ls - rs;
                break;
            }
            case ADD: {
                resultPrec = 2 * (lp - ls) + ls;
                resultScale = Math.max(ls, rs);
                break;
            }
            case AVG: {
                resultPrec = Math.max(lp - ls, rp - rs) + 1 + Math.max(ls, rs);
                resultScale = Math.max(Math.max(ls, rs), 4);
                break;
            }
            case OTHERS: {
                resultPrec = Math.max(lp - ls, rp - rs) + 1 + Math.max(ls, rs);
                resultScale = Math.max(ls, rs);
            }
        }
        return new Pair((Object)resultPrec, (Object)resultScale);
    }

    public static enum Operation {
        MULTIPLY,
        DIVIDE,
        ADD,
        AVG,
        OTHERS;

    }
}

