/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.metrics;

public enum MetricInfo {
    TRACE("", "trace_id"),
    SPAN("span_id", "span_id"),
    PARENT("parent_id", "parent_id"),
    START("start_time", "start_time"),
    END("end_time", "end_time"),
    TAG("phoenix.tag", "t"),
    ANNOTATION("phoenix.annotation", "a"),
    HOSTNAME("Hostname", "hostname"),
    DESCRIPTION("", "description");

    public final String traceName;
    public final String columnName;

    private MetricInfo(String traceName, String columnName) {
        this.traceName = traceName;
        this.columnName = columnName;
    }

    public static String getColumnName(String traceName) {
        for (MetricInfo info : MetricInfo.values()) {
            if (!info.traceName.equals(traceName)) continue;
            return info.columnName;
        }
        throw new IllegalArgumentException("Unknown tracename: " + traceName);
    }
}

