/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.index.IndexMetaDataCacheFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;

public class IndexMetaDataCacheClient {
    private final ServerCacheClient serverCache;
    private PTable cacheUsingTable;

    public IndexMetaDataCacheClient(PhoenixConnection connection, PTable cacheUsingTable) {
        this.serverCache = new ServerCacheClient(connection);
        this.cacheUsingTable = cacheUsingTable;
    }

    public static boolean useIndexMetadataCache(PhoenixConnection connection, List<? extends Mutation> mutations, int indexMetaDataByteLength) {
        ReadOnlyProps props = connection.getQueryServices().getProps();
        int threshold = props.getInt("phoenix.index.mutableBatchSizeThreshold", 3);
        return indexMetaDataByteLength > 8 && mutations.size() > threshold;
    }

    public ServerCacheClient.ServerCache addIndexMetadataCache(List<? extends Mutation> mutations, ImmutableBytesWritable ptr, byte[] txState) throws SQLException {
        return this.serverCache.addServerCache(ScanUtil.newScanRanges(mutations), ptr, txState, new IndexMetaDataCacheFactory(), this.cacheUsingTable);
    }

    public ServerCacheClient.ServerCache addIndexMetadataCache(ScanRanges ranges, ImmutableBytesWritable ptr, byte[] txState) throws SQLException {
        return this.serverCache.addServerCache(ranges, ptr, txState, new IndexMetaDataCacheFactory(), this.cacheUsingTable);
    }

    public static ServerCacheClient.ServerCache setMetaDataOnMutations(PhoenixConnection connection, PTable table, List<? extends Mutation> mutations, ImmutableBytesWritable indexMetaDataPtr) throws SQLException {
        boolean hasIndexMetaData;
        byte[] tenantIdBytes = table.isMultiTenant() ? (connection.getTenantId() == null ? null : ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, connection.getTenantId(), table.getViewIndexId() != null)) : (connection.getTenantId() == null ? null : connection.getTenantId().getBytes());
        ServerCacheClient.ServerCache cache = null;
        byte[] attribValue = null;
        byte[] uuidValue = null;
        byte[] txState = ByteUtil.EMPTY_BYTE_ARRAY;
        if (table.isTransactional()) {
            txState = connection.getMutationState().encodeTransaction();
        }
        boolean bl = hasIndexMetaData = indexMetaDataPtr.getLength() > 0;
        if (hasIndexMetaData) {
            if (IndexMetaDataCacheClient.useIndexMetadataCache(connection, mutations, indexMetaDataPtr.getLength() + txState.length)) {
                IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(connection, table);
                cache = client.addIndexMetadataCache(mutations, indexMetaDataPtr, txState);
                uuidValue = cache.getId();
            } else {
                attribValue = ByteUtil.copyKeyBytesIfNecessary(indexMetaDataPtr);
                uuidValue = ServerCacheClient.generateId();
            }
        } else if (txState.length == 0) {
            return null;
        }
        for (Mutation mutation : mutations) {
            if (connection.getTenantId() != null) {
                mutation.setAttribute("TenantId", tenantIdBytes);
            }
            mutation.setAttribute("IdxUUID", uuidValue);
            if (attribValue != null) {
                mutation.setAttribute("IdxProtoMD", attribValue);
                mutation.setAttribute("_ClientVersion", Bytes.toBytes((int)MetaDataProtocol.PHOENIX_VERSION));
                if (txState.length <= 0) continue;
                mutation.setAttribute("_TxState", txState);
                continue;
            }
            if (hasIndexMetaData || txState.length <= 0) continue;
            mutation.setAttribute("_TxState", txState);
        }
        return cache;
    }
}

